import Adw from 'gi://Adw';
import GObject from 'gi://GObject';
import Gtk from 'gi://Gtk';
export default class MetaTypeRow extends Adw.ActionRow {
    static {
        GObject.registerClass(
            {
                GTypeName: 'DeskChangerUiPrefsCommonMetaTypeRow',
                Signals: {
                    'delete-clicked': {},
                },
            },
            this
        );
    }
    #delete_button;
    #delete_clicked_id;

    vfunc_realize() {
        super.vfunc_realize();
        const box = this.get_child() || null;
        if (!box) return;
        this.#delete_button = new Gtk.Button({
            icon_name: 'user-trash-symbolic',
        });
        this.#delete_clicked_id = this.#delete_button.connect('clicked', () =>
            this.emit('delete-clicked')
        );
        box.append(this.#delete_button);
    }

    vfunc_unrealize() {
        super.vfunc_unrealize();
        if (this.#delete_clicked_id) {
            this.#delete_button.disconnect(this.#delete_clicked_id);
            this.#delete_clicked_id = undefined;
        }
        this.#delete_button = undefined;
    }
}
