import St from 'gi://St';
import Gio from 'gi://Gio';
import Pango from 'gi://Pango';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import * as PanelMenu from 'resource:///org/gnome/shell/ui/panelMenu.js';
import * as PopupMenu from 'resource:///org/gnome/shell/ui/popupMenu.js';
import Clutter from 'gi://Clutter';


let panel,scrollBase;

export default class ExampleExtension {
    constructor(){
        
        this.con_inptextNote = "";
        this.pathglobal = '/home/bitcas/Documentos/MAGOBITCAS';
    } 
    enable(){
        panel = new PanelMenu.Button(0,'Mainnav',false);
        panel.add_style_class_name('main'); 
        //con this is container o section
        this._navhead();
        this._conBtnaddNote();
        this._setContextNote();
        this._conlistnote();
        this._initmonitor_md();
        
        Main.panel.addToStatusArea(this.uuid, panel, 0, "right");
            
    }
    //ui design top panel
    _navhead()
    {
        let labelnav =  new St.Label({
            style_class : "label",
            text: '🃁🃜🃚🃖🂭🂺',
            y_align: Clutter.ActorAlign.CENTER,
        });
        panel.add_child(labelnav);
    }
    //add button for add containe ui
    _conBtnaddNote()
    {
        let popupanel =  new PopupMenu.PopupBaseMenuItem({
            reactive : false,
            can_focus : false
        },);
        popupanel.add_style_class_name("conbtunplus");
        let boxLayoutbtn = new St.BoxLayout({ x_align: Clutter.ActorAlign.CENTER, x_expand: true });   
        let Icon = new PopupMenu.PopupImageMenuItem("", "list-add-symbolic", {style_class: 'control-button'});   
        boxLayoutbtn.add_child(Icon);
        popupanel.add_child(boxLayoutbtn);
        panel.menu.addMenuItem(popupanel);
        
        //event
        Icon.connect('activate',()=>{
            this.con_inptextNote.visible = this.con_inptextNote.visible== true ? false  : true;
        })
    }
    _setContextNote()
    {
        this.con_inptextNote=  new PopupMenu.PopupBaseMenuItem({
            reactive : false,
            can_focus : false
        },);
        this.con_inptextNote.add_style_class_name("coninpnote");
         let inputextnote= new St.Entry({
            style_class:"inpnote",
            text: "Ubicacion .md",
            // Estas propiedades ayudan, pero la altura y el wrap suelen requerir CSS.
            // Usaremos un truco de estilo más adelante.
            x_expand: true,
            y_expand: true,
        });
        //event

        inputextnote.clutter_text.connect('activate',(actor)=>{
            scrollBase.destroy();
            let dire =  actor.get_text();
            this.pathglobal=dire;
            this._conlistnote();
        })
        this.con_inptextNote.visible = false;
        const layout = new St.BoxLayout({ x_align: Clutter.ActorAlign.CENTER, x_expand: true });
        layout.add_child(inputextnote);
        this.con_inptextNote.add_child(layout);
        panel.menu.addMenuItem(this.con_inptextNote);           
    }
    _conlistnote()
    {
       
        let scrollView = new St.ScrollView({
            //style: 'height:700px ; width: 450px;',
            overlay_scrollbars:true, 
            hscrollbar_policy:2, 
            enable_mouse_scrolling: true, 
            x_expand: true, 
            y_expand: true,
        });
        scrollBase  = new PopupMenu.PopupMenuSection();
        scrollBase.actor.add_child(scrollView);
         //container
        let listContainer = new St.BoxLayout({
            vertical: true,
            x_expand: true,// Permite que las notas llenen el ancho del scroll
            y_expand: true,
        });
        //function get list files md return paths 
        const listfile = this._readallfilemd();
        listfile.map((item)=>{
            const data =  this._readmd(item);
            //transforma el datoa
            let datarender = data.replace(/^## (.*$)/gm, '<span size="large" weight="bold">$1</span>');
            datarender = datarender.replace(/^# (.*$)/gm, '<span size="x-large" weight="bold">$1</span>');
            datarender = datarender.replace(/^# (.*$)/gm, '<span size="x-large" weight="bold">$1</span>');
            datarender = datarender.replace(/\*\*(.*?)\*\*/g, '<b>$1</b>');
            datarender = datarender.replace(/```([\s\S]*?)```/g, '<span font_family="monospace" background="#333">$1</span>');
            datarender = datarender.replace(/^\s*[\-\*]\s+(.*$)/gm, '  • $1');//listas
            datarender = datarender.replace(/\[\[(.*?)\]\]/g, '<span color="#99c1f1"><u>$1</u></span>');//subrayado
           let popupanel = new PopupMenu.PopupMenuItem(datarender);
           popupanel.label.clutter_text.use_markup = true;//damos los diselo 
            // 3. Volvemos a asignar el texto pero como 'markup'
            popupanel.label.clutter_text.set_markup(datarender);
            popupanel.add_style_class_name("note");
            listContainer.add_child(popupanel)
            
        })   
        scrollView.add_child(listContainer)
        
        panel.menu.addMenuItem(scrollBase);
    }
    //fn read file .md
    _readmd(path)
    {
        //read the path
        const file = Gio.File.new_for_path(path);
        try {
            const [success, contents] = file.load_contents(null);
            if (success) {
                // 3. Convertimos Uint8Array a String usando TextDecoder (estándar moderno)
                const decoder = new TextDecoder('utf-8');
                return decoder.decode(contents);
            }
        } catch (e) {
            console.error(`Error leyendo el archivo: ${e.message}`)
        }
        return  null;
    }
    _readallfilemd()
    {
        let folder = Gio.File.new_for_path(this.pathglobal);
        let filesmd = [];
        // Definimos qué atributos queremos (el nombre en este caso)
        let enumerator = folder.enumerate_children(
            'standard::name',
            Gio.FileQueryInfoFlags.NONE,
            null
        );
        let fileInfo;
        while ((fileInfo = enumerator.next_file(null)) !== null) {
            let fileName = fileInfo.get_name();
            
            // Filtramos solo los que terminan en .md
            if (fileName.endsWith('.md')) {
                filesmd.push(`${this.pathglobal}/${fileName}`);              
            }
        }
        return filesmd;
    }
    //init monitoreo de archivos md para ver los cambios
    _initmonitor_md()
    {
        //function get list files md return paths 
        const listfile = this._readallfilemd();
        listfile.map((path)=>{
            const file = Gio.File.new_for_path(path);
            // 1. Creamos el monitor
            this._monitor = file.monitor_file(Gio.FileMonitorFlags.NONE, null);
            // 2. Conectamos la señal 'changed'
            this._monitorId = this._monitor.connect('changed', (monitor, file, otherFile, eventType) => {
                // El evento 1 es Gio.FileMonitorEvent.CHANGED (cuando se guarda el contenido)
                // El evento 8 es Gio.FileMonitorEvent.CHANGES_DONE_HINT (cuando termina de escribirse)
                if (eventType === Gio.FileMonitorEvent.CHANGES_DONE_HINT || 
                    eventType === Gio.FileMonitorEvent.CHANGED) {
                    scrollBase.destroy();
                    console.log("¡El archivo MD ha cambiado! Recargando...");
                    this._conlistnote();
                
                } 
            });
        }) 

        

    }
    //listar todos los archivos .md
    
    __
    disable(){
       
        Main.panel._rightBox.remove_child(panel);
        panel?.destroy();
        //this.panel.destroy();
        // Liberar referencias para evitar fugas de memoria
        //panelButton = null;
        //panelButtonText = null
    }
    
}
