import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import HotkeyListener from './utils/hotkey-listener.js';

class ApplicationHotkeysExtension extends Extension {
  #hotkeyListener;

  enable() {
    this.#hotkeyListener = new HotkeyListener(this.getSettings());
  }

  disable() {
    this.#hotkeyListener?.dispose();
    this.#hotkeyListener = void 0;
  }
}

export { ApplicationHotkeysExtension as default };
