import * as MessageTray from 'resource:///org/gnome/shell/ui/messageTray.js';
import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';

export default class MyNotificationExtension extends Extension {
    enable() {
        // Save the original destroy function
        this._oldDestroy = MessageTray.Notification.prototype.destroy;

        // Save a reference to the class for use inside the function
        const oldDestroy = this._oldDestroy;

        // Replace with the new logic
        MessageTray.Notification.prototype.destroy = function (reason) {
            // Reason 3 is usually 'NotificationExpired'
            if (reason !== 3) {
                oldDestroy.call(this, reason);
            }
        };
    }

    disable() {
        // Restore the original function when the extension is turned off
        if (this._oldDestroy) {
            MessageTray.Notification.prototype.destroy = this._oldDestroy;
            this._oldDestroy = null;
        }
    }
}