import Gio from 'gi://Gio';
import {Extension} from 'resource:///org/gnome/shell/extensions/extension.js';

const DBUS_IFACE = `
<node>
   <interface name="org.gnome.Shell.Extensions.SwitchWorkspace">
      <method name="SwitchToWorkspace">
         <arg type="u" direction="in" name="index" />
      </method>
      <method name="GetWorkspaceInfo">
         <arg type="s" direction="out" name="info" />
      </method>
      <method name="GetCurrentWorkspace">
         <arg type="u" direction="out" name="index" />
      </method>
      <method name="GetWorkspaceCount">
         <arg type="u" direction="out" name="count" />
      </method>
   </interface>
</node>`;

export default class SwitchWorkspaceExtension extends Extension {
    enable() {
        this._dbus = Gio.DBusExportedObject.wrapJSObject(DBUS_IFACE, this);
        this._dbus.export(Gio.DBus.session, '/org/gnome/Shell/Extensions/SwitchWorkspace');
    }

    disable() {
        this._dbus.flush();
        this._dbus.unexport();
        delete this._dbus;
    }

    SwitchToWorkspace(index) {
        const workspaceManager = global.workspace_manager;
        const workspace = workspaceManager.get_workspace_by_index(index);
        
        if (!workspace) {
            throw new Error(`SwitchToWorkspace.invalid_workspace_index:${index}`);
        }

        workspace.activate(global.get_current_time());
    }

    GetWorkspaceInfo() {
        const workspaceManager = global.workspace_manager;
        const info = {
            current: workspaceManager.get_active_workspace_index(),
            count: workspaceManager.get_n_workspaces()
        };
        return JSON.stringify(info);
    }

    GetCurrentWorkspace() {
        const workspaceManager = global.workspace_manager;
        return workspaceManager.get_active_workspace_index();
    }

    GetWorkspaceCount() {
        const workspaceManager = global.workspace_manager;
        return workspaceManager.get_n_workspaces();
    }
}
