var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _XWinWaylandExtension_dbus;

const GLib = imports.gi.GLib;
const Gio = imports.gi.Gio;
const Shell = imports.gi.Shell;
const { Gtk: St } = imports.gi;
/**
 * Gnome Extension for x-win project
 */
class XWinWaylandExtension {
    constructor() {

        _XWinWaylandExtension_dbus.set(this, undefined);
    }
    /**
     *
     */
    enable() {
        __classPrivateFieldSet(this, _XWinWaylandExtension_dbus, Gio.DBusExportedObject.wrapJSObject(XWinWaylandExtension.DBUS_OBJECT, this), "f");
        __classPrivateFieldGet(this, _XWinWaylandExtension_dbus, "f").export(Gio.DBus.session, '/org/gnome/Shell/Extensions/XWinWaylandExtension');
    }
    /**
     *
     */
    disable() {
        if (__classPrivateFieldGet(this, _XWinWaylandExtension_dbus, "f") !== undefined) {
            __classPrivateFieldGet(this, _XWinWaylandExtension_dbus, "f").flush();
            __classPrivateFieldGet(this, _XWinWaylandExtension_dbus, "f").unexport();
        }
        __classPrivateFieldSet(this, _XWinWaylandExtension_dbus, undefined, "f");
    }
    /**
     *
     */
    get_open_windows() {
        const open_windows = global
            .get_window_actors()
            .filter(value => {
            return this._filterWindow(value);
        })
            .map(value => {
            return this._strcutData(value);
        });
        return JSON.stringify(open_windows);
    }
    /**
     *
     */
    get_active_window() {
        const active_window = global.get_window_actors().find(window_actor => {
            var _a;
            return (((_a = window_actor.get_meta_window()) === null || _a === void 0 ? void 0 : _a.has_focus()) &&
                this._filterWindow(window_actor));
        });
        const windowInfo = this._strcutData(active_window);
        return JSON.stringify(windowInfo);
    }
    /**
     *
     */
    get_icon(window_id) {
        const iconInfo = this._getIcon(window_id);
        return JSON.stringify(iconInfo);
    }
    _emptyIconInfo() {
        return {
            data: '',
            height: 0,
            width: 0,
        };
    }
    _emptyWindowInfo() {
        return {
            id: 0,
            os: 'linux',
            title: '',
            info: {
                process_id: 0,
                path: '',
                exec_name: '',
                name: '',
            },
            position: {
                width: 0,
                height: 0,
                x: 0,
                y: 0,
                isFullScreen: false,
            },
            usage: { memory: 0 },
        };
    }
    _getIcon(window_id) {
        var _a;
        const windowActors = global
            .get_window_actors()
            .filter(this._filterWindow);
        const metaWindow = (_a = windowActors
            .find(windowActor => { var _a; return ((_a = windowActor.get_meta_window()) === null || _a === void 0 ? void 0 : _a.get_id()) === window_id; })) === null || _a === void 0 ? void 0 : _a.get_meta_window();
        if (!metaWindow || !metaWindow.get_id) {
            return this._emptyIconInfo();
        }
        const tracker = Shell.WindowTracker.get_default();
        const windowApp = tracker.get_window_app(metaWindow);
        const windowIcon = windowApp.get_icon();
        const iconTheme = new St.IconTheme();
        const iconInfo = iconTheme.lookup_by_gicon(windowIcon, 128, St.IconLookupFlags.FORCE_SIZE);
        if (!iconInfo || !iconInfo.load_icon) {
            return this._emptyIconInfo();
        }
        const icon_buffer = iconInfo.load_icon();
        const [success, unitArray] = icon_buffer.save_to_bufferv('png', [], []);
        if (!success) {
            return this._emptyIconInfo();
        }
        const data = GLib.base64_encode(unitArray);
        return {
            data: 'data:image/png;base64,' + data,
            height: icon_buffer.get_height(),
            width: icon_buffer.get_width(),
        };
    }
    _filterWindow(window_actor, _index, _array) {
        var _a;
        return ((_a = window_actor.get_meta_window()) === null || _a === void 0 ? void 0 : _a.get_window_type()) !== -1;
    }
    _strcutData(window_actor) {
        if (!window_actor || !window_actor.get_meta_window) {
            return this._emptyWindowInfo();
        }
        const metaWindow = window_actor.get_meta_window();
        if (!metaWindow) {
            return this._emptyWindowInfo();
        }
        const process_id = metaWindow.get_pid ? metaWindow.get_pid() : 0;
        const info = Object.assign(this._getProcessInfo(process_id), {
            name: metaWindow.get_wm_class ? metaWindow.get_wm_class() : '',
            process_id,
        });
        return Object.assign(this._emptyWindowInfo(), {
            id: metaWindow.get_id ? metaWindow.get_id() : 0,
            info,
            title: metaWindow.get_title ? metaWindow.get_title() : '',
            position: {
                width: window_actor.get_width ? window_actor.get_width() : 0,
                height: window_actor.get_height ? window_actor.get_height() : 0,
                x: window_actor.get_x ? window_actor.get_x() : 0,
                y: window_actor.get_y ? window_actor.get_y() : 0,
                isFullScreen: metaWindow.is_fullscreen
                    ? metaWindow.is_fullscreen()
                    : false,
            },
            usage: { memory: this._getMemoryUsage(process_id) },
        });
    }
    _getMemoryUsage(pid) {
        const [isOk, contents] = GLib.file_get_contents(`/proc/${pid}/statm`);
        if (isOk) {
            return parseInt(contents.toString().split(' ')[0], 10);
        }
        return 0;
    }
    _getProcessInfo(process_id) {
        const process_info = {
            path: '',
            exec_name: '',
        };
        try {
            const path = GLib.file_read_link(`/proc/${process_id}/exe`);
            if (path) {
                process_info.path = path;
                process_info.exec_name = path.split('/').pop() || '';
            }
        }
        catch (_a) {
            /* empty */
        }
        return process_info;
    }
}
_XWinWaylandExtension_dbus = new WeakMap();
XWinWaylandExtension.DBUS_OBJECT = `
<node>
  <interface name="org.gnome.Shell.Extensions.XWinWaylandExtension">
    <method name="get_active_window">
      <arg name="value" type="s" direction="out" />
    </method>
    <method name="get_open_windows">
      <arg name="value" type="s" direction="out" />
    </method>
    <method name="get_icon">
      <arg name="value" type="d" direction="in" />
      <arg name="value" type="s" direction="out" />
    </method>
  </interface>
</node>
`;

function init() {
  return new XWinWaylandExtension();
}
