import St from "gi://St";
import * as PopupMenu from "resource:///org/gnome/shell/ui/popupMenu.js";
import { CONFIG } from '../utils/constants.js';

export class DisplaySettingsUI {
  constructor(indicator, settingsManager, onDisplayFormatChange) {
    this.indicator = indicator;
    this.settings = settingsManager;
    this.onDisplayFormatChange = onDisplayFormatChange;
    
    this._createSettingsSection();
  }

  _createSettingsSection() {
    // Display settings section
    const settingsLabel = new PopupMenu.PopupMenuItem("Display Settings:", {
      reactive: false,
    });
    settingsLabel.label.set_style("color: #ffffff; font-weight: bold;");
    this.indicator.menu.addMenuItem(settingsLabel);

    // Display format submenu
    this.formatSubmenu = new PopupMenu.PopupSubMenuMenuItem("Display Format");
    this.formatSubmenu.label.set_style("color: #ffffff;");
    
    const formats = [
      { id: "price-only", label: "Price Only" },
      { id: "price-with-change", label: "Price + Change" },
      { id: "price-with-percentage", label: "Price + Percentage" }
    ];
    
    formats.forEach(format => {
      const item = new PopupMenu.PopupMenuItem(format.label);
      item.connect("activate", () => this._handleFormatChange(format.id));
      this.formatSubmenu.menu.addMenuItem(item);
    });
    
    this.indicator.menu.addMenuItem(this.formatSubmenu);
    
    // History points slider
    this._createHistoryPointsItem();
    
    this.indicator.menu.addMenuItem(new PopupMenu.PopupSeparatorMenuItem());
    
    // Initialize displays
    this._updateFormatDisplay();
    this._updateHistoryPointsDisplay();
  }

_createHistoryPointsItem() {
    const maxPoints = this.settings.getHistoryMaxPoints();
    
    // Create simple menu with preset options
    this.historyPointsItem = new PopupMenu.PopupSubMenuMenuItem("History Points");
    this.historyPointsItem.label.set_style("color: #ffffff;");
    
    const options = [10, 25, 50, 75, 100];
    options.forEach(points => {
      const item = new PopupMenu.PopupMenuItem(`${points} points`);
      if (points === maxPoints) {
        item.label.set_style("color: #ffd700; font-weight: bold;");
      }
      
      item.connect("activate", () => {
        this.settings.setHistoryMaxPoints(points);
        this.historyPointsItem.label.set_text(`History Points (${points})`);
        
        // Update display of all options
        this.historyPointsItem.menu._getMenuItems().forEach((menuItem, index) => {
          if (options[index] === points) {
            menuItem.label.set_style("color: #ffd700; font-weight: bold;");
          } else {
            menuItem.label.set_style("color: #ffffff;");
          }
        });
      });
      
      this.historyPointsItem.menu.addMenuItem(item);
    });
    
    this.historyPointsItem.label.set_text(`History Points (${maxPoints})`);
    this.indicator.menu.addMenuItem(this.historyPointsItem);
  }

  _handleFormatChange(format) {
    if (format !== this.settings.getDisplayFormat()) {
      this.settings.setDisplayFormat(format);
      this._updateFormatDisplay();
      this.onDisplayFormatChange(format);
    }
  }

  _updateFormatDisplay() {
    const currentFormat = this.settings.getDisplayFormat();
    const formatLabels = {
      "price-only": "Price Only",
      "price-with-change": "Price + Change",
      "price-with-percentage": "Price + Percentage"
    };
    
    this.formatSubmenu.label.set_text(`Display Format (${formatLabels[currentFormat]})`);
  }

  _updateHistoryPointsDisplay() {
    const maxPoints = this.settings.getHistoryMaxPoints();
    this.historyPointsItem.label.set_text(`History Points (${maxPoints})`);
  }

  updateShowChartState(show) {
    this.showChartItem.setToggleState(show);
  }
}