import { CONFIG } from './constants.js';

export class SettingsManager {
  constructor(settings) {
    this.settings = settings;
  }

  getCurrency() {
    return this.settings.get_string("currency");
  }

  setCurrency(currency) {
    this.settings.set_string("currency", currency);
  }

  getAlertPrice() {
    return this.settings.get_double("alert-price");
  }

  setAlertPrice(price) {
    this.settings.set_double("alert-price", price);
  }

  getAlertTriggered() {
    return this.settings.get_boolean("alert-triggered");
  }

  setAlertTriggered(triggered) {
    this.settings.set_boolean("alert-triggered", triggered);
  }

  getLastPrice() {
    return this.settings.get_double("last-price");
  }

  setLastPrice(price) {
    this.settings.set_double("last-price", price);
  }

  clearAlert() {
    this.setAlertPrice(0.0);
    this.setAlertTriggered(false);
  }

  getCurrencySymbol() {
    return this.getCurrency() === CONFIG.CURRENCIES.EUR ? "€" : "$";
  }

  getCurrencyDisplay() {
    return this.getCurrency().toUpperCase();
  }

  // Display format settings
  getDisplayFormat() {
    return this.settings.get_string("display-format");
  }

  setDisplayFormat(format) {
    this.settings.set_string("display-format", format);
  }

  showChart() {
    return this.settings.get_boolean("show-chart");
  }

  setShowChart(show) {
    this.settings.set_boolean("show-chart", show);
  }

  getHistoryMaxPoints() {
    return this.settings.get_int("history-max-points");
  }

  setHistoryMaxPoints(points) {
    this.settings.set_int("history-max-points", points);
  }

  // Access to raw settings object for complex operations
  getSettings() {
    return this.settings;
  }
}