import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import ExtensionFeature from '../../utils/extensionFeature.js';
import { OverviewGestureController, WorkspaceGestureController } from '../../utils/overviewAndWorkspaceGestureController.js';
import { OverviewBackgroundGesturesFeature } from './_overviewBackgroundGestures.js';
import { WindowPreviewGestureFeature } from './_windowPreviewGestures.js';
import { DesktopBackgroundGesturesFeature } from './_desktopBackgroundGestures.js';
import { settings } from '../../settings.js';

class BackgroundNavigationGesturesFeature extends ExtensionFeature {
    _overviewController;
    _wsController;
    constructor(pm) {
        super(pm);
        this._overviewController = new OverviewGestureController();
        this._wsController = new WorkspaceGestureController({
            monitorIndex: Main.layoutManager.primaryIndex
        });
        this.addSubFeature('desktop-background-gestures', pm => new DesktopBackgroundGesturesFeature({
            pm,
            overviewController: this._overviewController,
            wsController: this._wsController,
        }), settings.backgroundNavigationGestures.desktopBackgroundGesturesEnabled);
        this.addSubFeature('overview-background-gestures', pm => new OverviewBackgroundGesturesFeature({
            pm,
            overviewController: this._overviewController,
            wsController: this._wsController,
        }), settings.backgroundNavigationGestures.overviewBackgroundGesturesEnabled);
        this.addSubFeature('window-preview-gestures', pm => new WindowPreviewGestureFeature(pm), settings.backgroundNavigationGestures.windowPreviewGesturesEnabled);
    }
    destroy() {
        this._overviewController.destroy();
        this._wsController.destroy();
        super.destroy();
    }
}

export { BackgroundNavigationGesturesFeature };
