/* extension.js
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */
import Clutter from 'gi://Clutter';
import GLib from 'gi://GLib';
import AccountsService from 'gi://AccountsService';

import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import {Extension, gettext as _} from 'resource:///org/gnome/shell/extensions/extension.js';
import * as userWidget from 'resource:///org/gnome/shell/ui/userWidget.js';


const children = Main.panel.statusArea.quickSettings._system._systemItem.child.get_children();
let settingsItem;
let shutdownItem;
let screenshotItem;
let lockItem;

    for (const child of children) {
        if (child.constructor.name == "SettingsItem") {
                settingsItem = child;
        }
    }
    
    for (const child of children) {
        if (child.constructor.name == "ShutdownItem") {
                shutdownItem = child;
        }
    }
    
    for (const child of children) {
        if (child.constructor.name == "ScreenshotItem") {
                screenshotItem = child;
        }
    }
    
    for (const child of children) {
        if (child.constructor.name == "LockItem") {
                lockItem = child;
        }
    }

export default class QuickSettingsExampleExtension extends Extension {
    _modifySystemItem() {       

        shutdownItem.menu._header.hide();        
        
        var userManager = AccountsService.UserManager.get_default();
        var user = userManager.get_user(GLib.get_user_name());        
        this._avatar = new userWidget.UserWidget(user);
        shutdownItem.menu.box.insert_child_at_index(this._avatar, 1);
    }
    
    

   _queueModifySystemItem() {
        GLib.idle_add(GLib.PRIORITY_DEFAULT, () => {
            if (!Main.panel.statusArea.quickSettings._system)
                return GLib.SOURCE_CONTINUE;

            this._modifySystemItem();
            return GLib.SOURCE_REMOVE;
        });
    }
    enable() {        
        if (Main.panel.statusArea.quickSettings._system)
                this._modifySystemItem();
            else
               this._queueModifySystemItem();
    }

    disable() {      
        this._avatar.destroy();
        this._avatar = null;
        shutdownItem.menu._header.show();
        }
}
