import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import Meta from 'gi://Meta';
import Shell from 'gi://Shell';

export default class ToggleTopbarExtension extends Extension {
  enable() {
    this._settings = this.getSettings();

    this._topbarVisible = this._settings.get_boolean('topbar-visible') ?? false;

    // Inıtial state
    this._topbarVisible ? Main.panel.show() : Main.panel.hide();

    Main.wm.addKeybinding(
      'toggle-topbar-shortcut',
      this._settings,
      Meta.KeyBindingFlags.NONE,
      Shell.ActionMode.NORMAL,
      () => this._onShortcutPressed()
    );
  }

  disable() {
    this._settings = null;

    Main.panel.show();

    Main.wm.removeKeybinding('toggle-topbar-shortcut');
  }

  ///////////////////////////////////////////////////
  // _onShortcutPressed function
  ///////////////////////////////////////////////////
  _onShortcutPressed() {
    this._topbarVisible = this._settings.get_boolean('topbar-visible') ?? false;

    if (this._topbarVisible) {
      this._settings.set_boolean('topbar-visible', false);
      Main.panel.hide();
    } else {
      this._settings.set_boolean('topbar-visible', true);
      Main.panel.show();
    }
  }
}
