/*
    Copyright 2025 Roman Lefler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import { displayTime } from "./lang.js";
import { gettext as realGettext } from "./gettext.js";
export var Details;
(function (Details) {
    Details["TEMP"] = "temp";
    Details["CONDITION_TEXT"] = "conditionText";
    Details["FEELS_LIKE"] = "feelsLike";
    Details["WIND_SPEED_AND_DIR"] = "windSpeedAndDir";
    Details["HUMIDITY"] = "humidity";
    Details["GUSTS"] = "gusts";
    Details["UV_INDEX"] = "uvIndex";
    Details["PRESSURE"] = "pressure";
    Details["PRECIPITATION"] = "precipitation";
    Details["SUNRISE"] = "sunrise";
    Details["SUNSET"] = "sunset";
    Details["CLOUD_COVER"] = "cloudCover";
    Details["SUN_EVENT_COUNTDOWN"] = "sunEventCountdown";
})(Details || (Details = {}));
// Fake gettext to trick xgettext into
// translating these strings
function _g(s) {
    return s;
}
/**
 * Gets a string that should be passed into gettext.
 * THE CALLER MUST TRANSLATE THE VALUE.
 * THESE ARE NOT PASSED INTO GETTEXT.
 */
export const detailName = {
    temp: _g("Temperature"),
    conditionText: _g("Condition"),
    feelsLike: _g("Feels Like"),
    windSpeedAndDir: _g("Wind"),
    humidity: _g("Humidity"),
    gusts: _g("Gusts"),
    uvIndex: _g("UV High"),
    pressure: _g("Pressure"),
    precipitation: _g("Precipitation"),
    sunrise: _g("Sunrise"),
    sunset: _g("Sunset"),
    cloudCover: _g("Cloud Cover"),
    sunEventCountdown: _g("Sun Countdown")
};
export function displayDetail(w, detail, gettext, cfg, onlyValue = false) {
    if (detail === "invalid")
        return _g("Invalid");
    const value = w[detail];
    let fmt;
    if (typeof value.display === "function") {
        fmt = value.display(cfg);
    }
    else if (value instanceof Date) {
        fmt = displayTime(value, cfg);
    }
    else if (typeof value === "number") {
        fmt = `${Math.round(value)}`;
    }
    else
        throw new Error("Detail must implement Displayable or be a Date or number.");
    if (onlyValue)
        return fmt;
    const name = detailName[detail];
    return `${realGettext(name)}: ${fmt}`;
}
