import Adw from 'gi://Adw';
import Gtk from 'gi://Gtk';
import { gettext as _, } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';
import { KeybindingRow } from '../KeybindingRow.js';
import { AboutRow } from './about.js';
import { makeActiveRows } from './active.js';
import { makeCircleRows } from './circle.js';
import { makeIdleRow } from './idle.js';
import { makeShapeRow } from './shape.js';
export function pushPrefsPage(prefs, navView) {
    const navPage = new Adw.NavigationPage({
        title: _('Pointer Tracker'),
    });
    const mainPage = new Adw.PreferencesPage();
    const settings = prefs.getSettings();
    const appearanceGroup = new Adw.PreferencesGroup({
        title: _('Appearance'),
    });
    mainPage.add(appearanceGroup);
    const circleRows = makeCircleRows(settings);
    const idleRow = makeIdleRow(settings, navView);
    const shapeRow = makeShapeRow(settings, [...circleRows, idleRow]);
    appearanceGroup.add(shapeRow);
    for (const circleRow of circleRows) {
        appearanceGroup.add(circleRow);
    }
    appearanceGroup.add(idleRow);
    const activeGroup = new Adw.PreferencesGroup({
        title: _('Active state'),
    });
    mainPage.add(activeGroup);
    const activeRows = makeActiveRows(settings);
    for (const activeRow of activeRows) {
        activeGroup.add(activeRow);
    }
    const keybindingGroup = new Adw.PreferencesGroup({
        title: _('Keybindings'),
    });
    mainPage.add(keybindingGroup);
    const keybindRow = new KeybindingRow(settings, 'tracker-keybinding', _('Toggle Tracker'));
    keybindingGroup.set_header_suffix(keybindRow.resetButton);
    keybindingGroup.add(keybindRow);
    const adwVersion = parseFloat(Adw.VERSION_S.substring(0, 3));
    if (adwVersion >= 1.5) {
        const aboutGroup = new Adw.PreferencesGroup({ title: _('About') });
        mainPage.add(aboutGroup);
        const aboutRow = new AboutRow(prefs.metadata);
        aboutGroup.add(aboutRow);
    }
    const pageBox = new Gtk.Box({
        orientation: Gtk.Orientation.VERTICAL,
    });
    pageBox.append(new Adw.HeaderBar());
    pageBox.append(mainPage);
    navPage.set_child(pageBox);
    navView.push(navPage);
}
