// https://lyrion.org/reference/cli/playlist/#mode
export const LMS_PLAYER_STATE_PLAY = 'play';
export const LMS_PLAYER_STATE_STOP = 'stop';
export const LMS_PLAYER_STATE_PAUSE = 'pause';

// https://lyrion.org/reference/cli/playlist/#playlist-shuffle
export const LMS_SHUFFLE_OFF = 0;
export const LMS_SHUFFLE_BY_SONG = 1;
export const LMS_SHUFFLE_BY_ALBUM = 2;

// https://lyrion.org/reference/cli/playlist/#playlist-repeat
export const LMS_REPEAT_OFF = 0;
export const LMS_REPEAT_TRACK = 1;
export const LMS_REPEAT_PLAYLIST = 2;


// https://specifications.freedesktop.org/mpris/latest/Player_Interface.html#Enum:Loop_Status
export const MPRIS_LOOP_NONE = 'None';
export const MPRIS_LOOP_TRACK = 'Track';
export const MPRIS_LOOP_PLAYLIST = 'Playlist';

// https://specifications.freedesktop.org/mpris/latest/Player_Interface.html#Enum:Playback_Status
export const MPRIS_PLAYBACK_PLAYING = 'Playing';
export const MPRIS_PLAYBACK_PAUSED = 'Paused';
export const MPRIS_PLAYBACK_STOPPED = 'Stopped';
