export class SettingsSubscriber {
    settings;
    connections = [];
    constructor(settings) {
        this.settings = settings;
    }
    connect = (signal, callback) => {
        const connectionId = this.settings.connect(signal, callback);
        this.connections.push(connectionId);
        return connectionId;
    };
    disconnect() {
        for (const connection of this.connections) {
            this.settings.disconnect(connection);
        }
    }
}
