import { ScreenRecordingNotifier } from './gjs/notifiers/ScreenRecordingNotifier.js';
import { ScreenSharingNotifier } from './gjs/notifiers/ScreenSharingNotifier.js';
import { SettingsSubscriber } from './prefs/SettingsSubscriber.js';
import { Tracker } from './tracker/Tracker.js';
export class TrackerManager {
    tracker;
    activePref = false;
    screenSharingActivePref = false;
    screenSharingNotifier = new ScreenSharingNotifier();
    isSharing = false;
    screenSharingSub = null;
    screenRecordingActivePref = false;
    screenRecordingNotifier = new ScreenRecordingNotifier();
    isRecording = false;
    screenRecordingSub = null;
    settingsSub;
    constructor(settings) {
        this.settingsSub = new SettingsSubscriber(settings);
        this.tracker = new Tracker(settings);
        this.watchActivePref('activePref', 'tracker-active');
        this.watchActivePref('screenSharingActivePref', 'tracker-always-on-screen-sharing');
        this.screenSharingSub = this.screenSharingNotifier.subscribe((isSharing) => {
            this.isSharing = isSharing;
            this.updateActiveState();
        });
        if (this.screenSharingSub === null) {
            console.warn('Failed to subscribe to screensharing events.');
        }
        this.watchActivePref('screenRecordingActivePref', 'tracker-always-on-screen-recording');
        this.screenRecordingSub = this.screenRecordingNotifier.subscribe((isSharing) => {
            this.isSharing = isSharing;
            this.updateActiveState();
        });
        if (this.screenRecordingSub === null) {
            console.warn('Failed to subscribe to screensharing events.');
        }
        this.updateActiveState();
    }
    destroy() {
        this.settingsSub.disconnect();
        if (this.screenSharingSub !== null) {
            this.screenSharingNotifier.unsubscribe(this.screenSharingSub);
            this.screenSharingSub = null;
        }
        if (this.screenRecordingSub !== null) {
            this.screenRecordingNotifier.unsubscribe(this.screenRecordingSub);
            this.screenRecordingSub = null;
        }
        this.tracker.destroy();
    }
    watchActivePref(key, prefName) {
        this[key] = this.settingsSub.settings.get_boolean(prefName);
        const onActivePrefUpdate = () => {
            this[key] = this.settingsSub.settings.get_boolean(prefName);
            this.updateActiveState();
        };
        this.settingsSub.connect(`changed::${prefName}`, onActivePrefUpdate);
    }
    updateActiveState() {
        this.tracker.setActive(this.activePref ||
            (this.isSharing && this.screenSharingActivePref) ||
            (this.isRecording && this.screenRecordingActivePref));
    }
}
