# Folder Notes GNOME Shell Extension

![Screenshot](folder-notes-screenshot.png)

**Folder Notes** lets you organize text notes in folders directly from the GNOME Shell panel.  
Create, edit, rename, and delete notes and folders with a simple menu interface.  
Choose between light and dark themes for comfortable viewing.

## Features

- Organize notes in folders and subfolders
- Create, edit, rename, and delete `.txt` notes
- Rename and delete folders
- Switch between light and dark menu themes
- Customizable notes storage location

## Installation

1. **Clone or download this repository** into your GNOME Shell extensions directory:
    ```sh
    git clone https://github.com/Guilherme-Marquez/folder-notes.git ~/.local/share/gnome-shell/extensions/folder-notes@pmetis.opendev
    ```

2. **Compile the GSettings schema:**
    ```sh
    glib-compile-schemas ~/.local/share/gnome-shell/extensions/folder-notes@pmetis.opendev/schemas/
    ```

3. **Restart GNOME Shell** (press `Alt+F2`, type `r`, and press Enter) or log out and back in.

4. **Enable the extension** using GNOME Extensions app or `gnome-extensions enable folder-notes@pmetis.opendev`.

## Usage

- Click the Folder Notes icon in the top panel to open the menu.
- Add folders and notes using the input fields.
- Use the buttons to rename or delete items.
- Switch between light and dark themes in the preferences.

## Preferences

Open the preferences window from the Extensions app to:
- Change the notes storage folder
- Select light or dark theme

## License

This extension is licensed under the GNU General Public License v3.0 or later.  
See the [LICENSE](LICENSE) file for details.

**Attribution and recognition are always welcome!**  
If you find this extension useful, please consider starring the [GitHub repository](https://github.com/Guilherme-Marquez/folder-notes.git) or [buying me a coffee](https://buymeacoffee.com/pmetis).

## Contributing

Pull requests and issues are welcome!

## Support

For questions or bug reports, open an issue on the [GitHub repository](https://github.com/Guilherme-Marquez/folder-notes.git).
