import Adw from 'gi://Adw';
import Gtk from 'gi://Gtk';
import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

export default class FolderNotesPreferences extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        const settings = this.getSettings();

        const page = new Adw.PreferencesPage();
        
        const storageGroup = new Adw.PreferencesGroup({
            title: 'Notes Storage',
            description: 'Configure where your notes are saved',
        });

        const pathRow = new Adw.ActionRow({
            title: 'Notes Folder Path',
            subtitle: 'Leave empty for default (~/NotesExtension)',
        });

        const pathEntry = new Gtk.Entry({
            text: settings.get_string('notes-path'),
            hexpand: true,
            valign: Gtk.Align.CENTER,
        });

        pathEntry.connect('changed', () => {
            settings.set_string('notes-path', pathEntry.get_text());
        });

        pathRow.add_suffix(pathEntry);
        pathRow.activatable_widget = pathEntry;
        storageGroup.add(pathRow);
        page.add(storageGroup);

        const themeGroup = new Adw.PreferencesGroup({
            title: 'Appearance',
            description: 'Customize the menu appearance',
        });

        const themeRow = new Adw.ComboRow({
            title: 'Menu Theme',
            subtitle: 'Choose between light or dark theme',
        });

        const themeModel = new Gtk.StringList();
        themeModel.append('Dark');
        themeModel.append('Light');

        themeRow.set_model(themeModel);
        themeRow.set_selected(settings.get_string('theme') === 'light' ? 1 : 0);

        themeRow.connect('notify::selected-item', () => {
            settings.set_string('theme', themeRow.get_selected() === 1 ? 'light' : 'dark');
        });

        themeGroup.add(themeRow);

        const keyboardRow = new Adw.ActionRow({
            title: 'Enable Clipboard Shortcuts',
            subtitle: 'Allow Ctrl+C/Ctrl+V in note editor',
        });

        const keyboardSwitch = new Gtk.Switch({
            active: settings.get_boolean('enable-clipboard-shortcuts'),
            valign: Gtk.Align.CENTER,
        });

        keyboardSwitch.connect('notify::active', () => {
            settings.set_boolean('enable-clipboard-shortcuts', keyboardSwitch.get_active());
        });

        keyboardRow.add_suffix(keyboardSwitch);
        keyboardRow.activatable_widget = keyboardSwitch;
        themeGroup.add(keyboardRow);
        page.add(themeGroup);

        window.add(page);
    }
}