import Gettext from 'gettext';

export function initTranslations(extension) {
  const localeDir = extension.dir.get_child('locale');
  if (localeDir.query_exists(null)) {
    Gettext.bindtextdomain('advanced-media-controller', localeDir.get_path());
  }
}

export function gettext(str) {
  return Gettext.dgettext('advanced-media-controller', str);
}

export function ngettext(singular, plural, n) {
  return Gettext.dngettext('advanced-media-controller', singular, plural, n);
}