# Web Search with Bangs
Web Search with Bangs brings DuckDuckGo-style !bang search shortcuts to GNOME Shell. Define configurable bangs that route queries to Google directly from the overview, enabling fast, keyboard-driven searches.


# Web Search with Bangs

DuckDuckGo-style !bang search shortcuts for GNOME Shell Overview

---

## Features
- **!bang shortcuts**: Quickly search sites like GitHub, Stack Overflow, YouTube, Wikipedia, Google Maps, and more
- **Configurable**: Add, edit, or remove custom bangs in the preferences dialog
- **Google fallback**: Non-bang queries search Google by default
- **Native integration**: Uses GNOME's GSettings for preferences
- **Keyboard-driven**: Fast, efficient searching from the GNOME overview

## Default Bangs
| Shortcut   | Site                |
|-----------|---------------------|
| `!gh`     | GitHub              |
| `!so`     | Stack Overflow      |
| `!yt`     | YouTube             |
| `!wiki`   | Wikipedia           |
| `!map`    | Google Maps         |
| `!lc`     | LeetCode      |

## Installation
1. **Download** or clone this repository into your GNOME extensions directory:
   - `~/.local/share/gnome-shell/extensions/gnome-bang-search@ishaan-dandekar.github.io/`
2. **Compile GSettings schema**:
   ```bash
   glib-compile-schemas schemas/
   ```
3. **Restart GNOME Shell**:
   - Press <kbd>Alt</kbd>+<kbd>F2</kbd>, type `r`, and press <kbd>Enter</kbd>
   - Or log out and log back in
4. **Enable the extension**:
   - Use GNOME Extensions app or run:
     ```bash
     gnome-extensions enable gnome-bang-search@ishaan-dandekar.github.io
     ```

## Usage
- Open the GNOME overview (press <kbd>Super</kbd> or <kbd>Win</kbd> key)
- Type a bang shortcut (e.g. `!gh search term`) to search that site
- Type a regular query to search Google
- Configure custom bangs in the preferences dialog

## Preferences
- Accessible via the GNOME Extensions app or `gnome-extensions prefs gnome-bang-search@ishaan-dandekar.github.io`
- Add, edit, or delete bang shortcuts
- Changes are saved automatically

## Development
- Main files:
  - `extension.js`: Search provider logic
  - `prefs.js`: Preferences UI
  - `schemas/`: GSettings schema
  - `metadata.json`: Extension metadata
- To update default bangs, edit `DEFAULT_BANGS` in `extension.js`

## License
GPL-3.0

## Author
[Ishaan Dandekar](https://github.com/ishaan-dandekar)

---

For issues or suggestions, open an issue on [GitHub](https://github.com/ishaan-dandekar/gnome-bang-search).
