/* -*- mode: js2; js2-basic-offset: 4; indent-tabs-mode: nil -*- */

// Strict mode.
"use strict";

// Import modules.
import * as Main from "resource:///org/gnome/shell/ui/main.js";

import { Extension } from "resource:///org/gnome/shell/extensions/extension.js";

import * as Menu from "./libs/extension/menu.js";

/**
 * Main Extension class for GNOME 45+.
 *
 * The extension.js is a required file of every extension. It is the core
 * of your extension and contains the function hooks init(), enable() and
 * disable() used by GNOME Shell to load, enable and disable your
 * extension.
 *
 * https://gjs.guide/extensions/overview/anatomy.html#extension-js-required
 */
export default class PrimeIndicatorExtension extends Extension {
  /**
   * Constructor.
   *
   * @return {Void}
   */
  constructor(metadata) {
    super(metadata);
    this._indicator = null;
  }

  /**
   * This function is called when your extension is enabled, which could
   * be done in GNOME Extensions, when you log in or when the screen is
   * unlocked.
   *
   * This is when you should setup any UI for your extension, change
   * existing widgets, connect signals or modify GNOME Shell's
   * behaviour.
   *
   * @return {Void}
   */
  enable() {
    if (this._indicator) return;

    this._indicator = new Menu.Indicator(this);
    Main.panel.statusArea.quickSettings.addExternalIndicator(this._indicator);
  }

  /**
   * This function is called when your extension is uninstalled, disabled in
   * GNOME Extensions, when you log out or when the screen locks.
   *
   * Anything you created, modifed or setup in enable() MUST be undone here.
   * Not doing so is the most common reason extensions are rejected in
   * review!
   *
   * @return {Void}
   */
  disable() {
    if (!this._indicator) return;

    this._indicator.destroy();
    this._indicator = null;
  }
}
