/* -*- mode: js2; js2-basic-offset: 4; indent-tabs-mode: nil -*- */

// Strict mode.
"use strict";

import GObject from "gi://GObject";
import Gio from "gi://Gio";

/**
 * Default icon.
 *
 * @type {String}
 */
export const DEFAULT = "prime-menu-default-symbolic";

/**
 * Donation icon.
 *
 * @type {String}
 */
export const DONATION = "prime-menu-donation-symbolic";

/**
 * GitHub icon.
 *
 * @type {String}
 */
export const GITHUB = "prime-menu-github-symbolic";

/**
 * Get icon path (directory name). If filename argument is
 * provided it will be appended to path. Note that there
 * is no file exists check here.
 *
 * @param  {String}  extensionPath
 * @param  {Mixed}   filename (optional)
 * @return {String}
 */
export function path(extensionPath, filename = null) {
  let dirname = `${extensionPath}/icons`;
  let suffix = filename ? `/${filename}` : "";

  return dirname + suffix;
}

/**
 * Icons.Icon extends Gio.FileIcon.
 */
export const Icon = GObject.registerClass(
  {
    GTypeName: "PrimeIndicatorIconsIcon",
  },
  class Icon extends Gio.FileIcon {
    /**
     * Constructor.
     *
     * @param  {String} extensionPath
     * @param  {Mixed}  icon
     * @return {Void}
     */
    _init(extensionPath, icon = null) {
      let iconName = icon || DEFAULT;
      let iconPath = path(extensionPath, `${iconName}.svg`);
      let file = Gio.File.new_for_path(iconPath);

      return super._init({ file: file });
    }
  },
);
