/* -*- mode: js2; js2-basic-offset: 4; indent-tabs-mode: nil -*- */

// Strict mode.
"use strict";

/**
 * Proxy for console.log.
 *
 * @param  {String}    widget
 * @param  {...String} message
 * @return {Void}
 */
export function journal(widget, ...message) {
  const prefix = "[prime-indicator" + (widget ? "." + widget : "") + "]";

  let args = [prefix + (message.length ? " " + message.shift() : "")];
  if (message.length) args = args.concat(message);

  console.log.apply(console, args);
}
