/* -*- mode: js2; js2-basic-offset: 4; indent-tabs-mode: nil -*- */

// Strict mode.
"use strict";

import { ExtensionPreferences } from "resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js";

import { Widget } from "./libs/prefs/widget.js";

/**
 * Extension preferences class for GNOME 45+.
 *
 * Initialize extension preferences and fill the preferences window.
 */
export default class PrimeIndicatorPreferences extends ExtensionPreferences {
  /**
   * Fill the preferences window (Adw.PreferencesWindow).
   *
   * @param  {Adw.PreferencesWindow} window
   * @return {Void}
   */
  fillPreferencesWindow(window) {
    new Widget(window, this);
  }
}
