import Context from '../core/context.js';

const _ = Context.gettext;

/** @enum {string} */
export const Label = {
    Pin: _('Pin'),
    SoundVolumeControl: _('Sound Volume Control'),
    Customize: _('Customize'),
    ActivationBehavior: _('Activation Behavior'),
    AttentionBehavior: _('Attention Behavior'),
    AttentionNotifications: _('Attention Notifications'),
    StandardNotifications: _('Standard Notifications'),
    CustomIcon: _('Custom Icon'),
    IconSize: _('Icon Size'),
    IconFromClipboard: _('Icon from Clipboard'),
    NoIconInClipboard: _('No Icon Found in Clipboard'),
    ResetToDefault: _('Reset to Default'),
    ResetAllToDefault: _('Reset All to Default'),
    FindWindow: _('Find Window'),
    MoveWindows: _('Move Windows'),
    FocusActive: _('Set Focus When Active'),
    FocusWorkspace: _('Set Focus On Active Workspace'),
    FocusAll: _('Always Set Focus'),
    SelectIcon: _('Select Icon'),
    Icon: _('Icon'),
    Default: _('Default'),
    CurrentWorkspace: _('Current Workspace'),
    OtherWorkspaces: _('Other Workspaces'),
    MinimizeAll: _('Minimize All'),
    RaiseAll: _('Raise All'),
    CloseAll: _('Close All'),
    CurrentMonitor: _('This Monitor'),
    MonitorLeft: _('Monitor Left'),
    MonitorRight: _('Monitor Right'),
    MonitorAbove: _('Monitor Above'),
    MonitorBelow: _('Monitor Below'),
    MoveTo: _('Move to'),
    PreferredMonitor: _('Preferred Monitor'),
    PrimaryMonitor: _('Primary'),
    LeftOfPrimaryMonitor: _('Left of Primary'),
    RightOfPrimaryMonitor: _('Right of Primary'),
    AbovePrimaryMonitor: _('Above Primary'),
    BelowPrimaryMonitor: _('Below Primary'),
    Disable: _('Disable'),
    AlwaysHide: _('Always Hide'),
    AlwaysShow: _('Always Show'),
    Critical: _('Critical')
};
