'use strict';

import LinkBuds from './deviceConfigs/LinkBuds.js';
import LinkBudsS from './deviceConfigs/LinkBudsS.js';
import SonyULT from './deviceConfigs/Sony-ULT.js';
import WF1000XM3 from './deviceConfigs/WF-1000XM3.js';
import WF1000XM4 from './deviceConfigs/WF-1000XM4.js';
import WF1000XM5 from './deviceConfigs/WF-1000XM5.js';
import WFC500 from './deviceConfigs/WF-C500.js';
import WFC510 from './deviceConfigs/WF-C510.js';
import WFC700N from './deviceConfigs/WF-C700N.js';
import WFC710N from './deviceConfigs/WF-C710N.js';
import WFSP800N from './deviceConfigs/WF-SP800N.js';
import WH1000XM2 from './deviceConfigs/WH-1000XM2.js';
import WH1000XM3 from './deviceConfigs/WH-1000XM3.js';
import WH1000XM4 from './deviceConfigs/WH-1000XM4.js';
import WH1000XM5 from './deviceConfigs/WH-1000XM5.js';
import WH1000XM6 from './deviceConfigs/WH-1000XM6.js';
import WHCH720N from './deviceConfigs/WH-CH720N.js';
import WHXB910N from './deviceConfigs/WH-XB910N.js';
import WIC100 from './deviceConfigs/WI-C100.js';
import WISP600N from './deviceConfigs/WI-SP600N.js';

export const SonyConfiguration = [
    LinkBuds,
    LinkBudsS,
    SonyULT,
    WF1000XM3,
    WF1000XM4,
    WF1000XM5,
    WFC500,
    WFC510,
    WFC700N,
    WFC710N,
    WFSP800N,
    WH1000XM2,
    WH1000XM3,
    WH1000XM4,
    WH1000XM5,
    WH1000XM6,
    WHCH720N,
    WHXB910N,
    WIC100,
    WISP600N,
];

export const Checksum = {
    HEADER: 0x3E,
    TRAILER: 0x3C,
    ESCAPE: 0x3D,
    ESCAPE_MASK: 0xEF,
};

export const MessageType = {
    ACK: 0x01,
    COMMAND_1: 0x0C,
    COMMAND_2: 0x0E,
    UNKNOWN: 0xFF,
};

export const ValueType = {
    FIXED: 0x00,
    MODEL_NAME: 0x01,
    FW_VERSION: 0x02,
    SERIES_AND_COLOR_INFO: 0x03,
};

export const BatteryType = {
    SINGLE: 0x00,
    DUAL: 0x01,
    CASE: 0x02,
    SINGLE_THD: 0x08,
    DUAL_THD: 0x09,
    CASE_THD: 0x0A,
};

export const BatteryStatus = {
    NOT_CHARGING: 0x00,
    CHARGING: 0x01,
    UNKNOWN: 0x02,
    CHARGED: 0x03,
};

export const AsmType  = {
    NC_ON_OFF: 0x1,
    NC_ON_OFF_AND_ASM_ON_OFF: 0x11,
    NC_MODE_SWITCH_AND_ASM_ON_OFF: 0x12,
    NC_ON_OFF_AND_ASM_SEAMLESS: 0x13,
    NC_MODE_SWITCH_AND_ASM_SEAMLESS: 0x14,
    MODE_NC_ASM_AUTO_NC_MODE_SWITCH_AND_ASM_SEAMLESS: 0x15,
    MODE_NC_ASM_DUAL_SINGLE_NC_MODE_SWITCH_AND_ASM_SEAMLESS: 0x16,
    MODE_NC_ASM_DUAL_NC_MODE_SWITCH_AND_ASM_SEAMLESS: 0x17,
    MODE_NC_NCSS_ASM_DUAL_NC_MODE_SWITCH_AND_ASM_SEAMLESS: 0x18,
    MODE_NC_ASM_DUAL_NC_MODE_SWITCH_AND_ASM_SEAMLESS_NA: 0x19,
    ASM_ON_OFF: 0x21,
    ASM_SEAMLESS: 0x22,
    NC_AMB_TOGGLE: 0x30,
    NC_TEST_MODE: 0x40,
};

export const AmbientSoundMode = {
    ANC_OFF: 0x00,
    ANC_ON: 0x01,
    WIND: 0x02,
    AMBIENT: 0x03,
};

export const AutoAsmSensitivity = {
    STANDARD: 0x00,
    HIGH: 0x01,
    LOW: 0x02,
};

export const Speak2ChatSensitivity = {
    AUTO: 0x00,
    HIGH: 0x01,
    LOW: 0x02,
};

export const Speak2ChatTimeout = {
    SHORT: 0x00,
    STANDARD: 0x01,
    LONG: 0x02,
    OFF: 0x03,
};

export const ListeningMode = {
    CINEMA: 0x00,
    STANDARD: 0x01,
    BGM: 0x02, // Should not be sent
};

export const BgmDistance = {
    MY_ROOM: 0x00,
    LIVING_ROOM: 0x01,
    CAFE: 0x02,
};

export const EqInquiryType = {
    PRESET_EQ: 0x00,
    EBB: 0x01,
    PRESET_EQ_NONCUSTOMIZABLE: 0x02,
    PRESET_EQ_AND_ERRORCODE: 0x04,
    CUSTOM_EQ: 0x31,
};

export const EqualizerPreset = {
    OFF: 0x00,
    BRIGHT: 0x10,
    EXCITED: 0x11,
    MELLOW: 0x12,
    RELAXED: 0x13,
    VOCAL: 0x14,
    TREBLE_BOOST: 0x15,
    BASS_BOOST: 0x16,
    SPEECH: 0x17,
    MANUAL: 0xA0,
    CUSTOM_1: 0xA1,
    CUSTOM_2: 0xA2,
};

export const ButtonModes = {
    AMBIENT_SOUND_CONTROL: 0x00,
    VOLUME_CONTROL: 0x10,
    PLAYBACK_CONTROL: 0x20,
    PLAYBACK_CONTROL_W_LIMITATION: 0x22,
    AMBIENT_SOUND_CONTROL_QA: 0x35,
    NO_FUNCTION: 0xFF,
};

export const AmbientButtonMode = {
    NC_ASM_OFF: 0x01,
    NC_ASM: 0x02,
    NC_OFF: 0x03,
    ASM_OFF: 0x04,
};

export const AutoPowerOffState = {
    ENABLE: 0x10,
    DISABLE: 0x11,
};

export const AutoPowerOffTime = {
    AFTER_5_MIN: 0x00,
    AFTER_30_MIN: 0x01,
    AFTER_1_HOUR: 0x02,
    AFTER_3_HOUR: 0x03,
    AFTER_15_MIN: 0x04,
};

export const AudioCodec = {
    UNSETTLED: 0x00,
    SBC: 0x01,
    AAC: 0x02,
    LDAC: 0x10,
    APT_X: 0x20,
    APT_X_HD: 0x21,
    LC3: 0x30,
    OTHER: 0xFF,
};

export const DseeType = {
    DSEE_HX: 0x00,
    DSEE: 0x01,
    DSEE_HX_AI: 0x02,
    DSEE_ULTIMATE: 0x03,
};

export const PayloadTypeV1T1 = {
    CONNECT_GET_PROTOCOL_INFO: 0x00,
    CONNECT_RET_PROTOCOL_INFO: 0x01,
    CONNECT_GET_CAPABILITY_INFO: 0x02,
    CONNECT_GET_DEVICE_INFO: 0x04,
    CONNECT_RET_DEVICE_INFO: 0x05,
    CONNECT_GET_SUPPORT_FUNCTION: 0x06,
    CONNECT_RET_SUPPORT_FUNCTION: 0x07,
    COMMON_GET_BATTERY_LEVEL: 0x10,
    COMMON_RET_BATTERY_LEVEL: 0x11,
    COMMON_NTFY_BATTERY_LEVEL: 0x13,
    COMMON_GET_UPSCALING_EFFECT: 0x14,
    COMMON_RET_UPSCALING_EFFECT: 0x15,
    COMMON_NTFY_UPSCALING_EFFECT: 0x17,
    COMMON_GET_AUDIO_CODEC: 0x18,
    COMMON_RET_AUDIO_CODEC: 0x19,
    COMMON_NTFY_AUDIO_CODEC: 0x1B,
    VPT_GET_PARAM: 0x46,
    VPT_RET_PARAM: 0x47,
    VPT_SET_PARAM: 0x48,
    VPT_NTFY_PARAM: 0x49,
    EQ_EBB_GET_PARAM: 0x56,
    EQ_EBB_RET_PARAM: 0x57,
    EQ_EBB_SET_PARAM: 0x58,
    EQ_EBB_NTFY_PARAM: 0x59,
    NC_ASM_GET_PARAM: 0x66,
    NC_ASM_RET_PARAM: 0x67,
    NC_ASM_SET_PARAM: 0x68,
    NC_ASM_NTFY_PARAM: 0x69,
    AUDIO_GET_PARAM: 0xE6,
    AUDIO_RET_PARAM: 0xE7,
    AUDIO_SET_PARAM: 0xE8,
    AUDIO_NTFY_PARAM: 0xE9,
    SYSTEM_GET_PARAM: 0xF6,
    SYSTEM_RET_PARAM: 0xF7,
    SYSTEM_SET_PARAM: 0xF8,
    SYSTEM_NTFY_PARAM: 0xF9,
    SYSTEM_GET_EXTENDED_PARAM: 0xFA,
    SYSTEM_RET_EXTENDED_PARAM: 0xFB,
    SYSTEM_SET_EXTENDED_PARAM: 0xFC,
    SYSTEM_NTFY_EXTENDED_PARAM: 0xFD,
};

export const FunctionTypeV1T1 = {
    NO_USE: 0x00,
    BATTERY_LEVEL: 0x11,
    UPSCALING_INDICATOR: 0x12,
    CODEC_INDICATOR: 0x13,
    BLE_SETUP: 0x14,
    LEFT_RIGHT_BATTERY_LEVEL: 0x15,
    LEFT_RIGHT_CONNECTION_STATUS: 0x17,
    CRADLE_BATTERY_LEVEL: 0x18,
    POWER_OFF: 0x21,
    CONCIERGE_DATA: 0x22,
    TANDEM_KEEP_ALIVE: 0x23,
    FW_UPDATE: 0x30,
    PAIRING_DEVICE_MANAGEMENT_CLASSIC_BT: 0x38,
    VOICE_GUIDANCE: 0x39,
    VPT: 0x41,
    SOUND_POSITION: 0x42,
    PRESET_EQ: 0x51,
    EBB: 0x52,
    PRESET_EQ_NONCUSTOMIZABLE: 0x53,
    NOISE_CANCELLING: 0x61,
    NOISE_CANCELLING_AND_AMBIENT_SOUND_MODE: 0x62,
    AMBIENT_SOUND_MODE: 0x63,
    AUTO_NC_ASM: 0x71,
    NC_OPTIMIZER: 0x81,
    VIBRATOR_ALERT_NOTIFICATION: 0x92,
    PLAYBACK_CONTROLLER: 0xA1,
    TRAINING_MODE: 0xB1,
    ACTION_LOG_NOTIFIER: 0xC1,
    GENERAL_SETTING1: 0xD1,
    GENERAL_SETTING2: 0xD2,
    GENERAL_SETTING3: 0xD3,
    CONNECTION_MODE: 0xE1,
    UPSCALING: 0xE2,
    VIBRATOR: 0xF1,
    POWER_SAVING_MODE: 0xF2,
    CONTROL_BY_WEARING: 0xF3,
    AUTO_POWER_OFF: 0xF4,
    SMART_TALKING_MODE: 0xF5,
    ASSIGNABLE_SETTINGS: 0xF6,
};

export const PayloadTypeV2T1 = {
    CONNECT_GET_PROTOCOL_INFO: 0x00,
    CONNECT_RET_PROTOCOL_INFO: 0x01,
    CONNECT_GET_CAPABILITY_INFO: 0x02,
    CONNECT_RET_CAPABILITY_INFO: 0x03,
    CONNECT_GET_DEVICE_INFO: 0x04,
    CONNECT_RET_DEVICE_INFO: 0x05,
    CONNECT_GET_SUPPORT_FUNCTION: 0x06,
    CONNECT_RET_SUPPORT_FUNCTION: 0x07,
    COMMON_GET_STATUS: 0x12,
    COMMON_RET_STATUS: 0x13,
    COMMON_NTFY_STATUS: 0x15,
    POWER_GET_STATUS: 0x22,
    POWER_RET_STATUS: 0x23,
    POWER_NTFY_STATUS: 0x25,
    POWER_GET_PARAM: 0x26,
    POWER_RET_PARAM: 0x27,
    POWER_SET_PARAM: 0x28,
    POWER_NTFY_PARAM: 0x29,
    EQEBB_GET_PARAM: 0x56,
    EQEBB_RET_PARAM: 0x57,
    EQEBB_SET_PARAM: 0x58,
    EQEBB_NTFY_PARAM: 0x59,
    NCASM_GET_PARAM: 0x66,
    NCASM_RET_PARAM: 0x67,
    NCASM_SET_PARAM: 0x68,
    NCASM_NTFY_PARAM: 0x69,
    AUDIO_GET_PARAM: 0xE6,
    AUDIO_RET_PARAM: 0xE7,
    AUDIO_SET_PARAM: 0xE8,
    AUDIO_NTFY_PARAM: 0xE9,
    SYSTEM_GET_PARAM: 0xF6,
    SYSTEM_RET_PARAM: 0xF7,
    SYSTEM_SET_PARAM: 0xF8,
    SYSTEM_NTFY_PARAM: 0xF9,
    SYSTEM_GET_EXT_PARAM: 0xFA,
    SYSTEM_RET_EXT_PARAM: 0xFB,
    SYSTEM_SET_EXT_PARAM: 0xFC,
    SYSTEM_NTFY_EXT_PARAM: 0xFD,
};

export const PayloadTypeV2T2 = {
    VOICE_GUIDANCE_GET_PARAM: 0x46,
    VOICE_GUIDANCE_RET_PARAM: 0x47,
    VOICE_GUIDANCE_SET_PARAM: 0x48,
    VOICE_GUIDANCE_NTFY_PARAM: 0x49,
};

export const FunctionTypeV2T1 = {
    CONCIERGE_DATA: 0x10,
    CONNECTION_STATUS: 0x11,
    CODEC_INDICATOR: 0x12,
    UPSCALING_INDICATOR: 0x13,
    BLE_SETUP: 0x14,
    TUTORIAL_CONTENTS_SELECT_ON_CONCIERGE: 0x15,
    CONNECTION_ESTABLISHED_TIME: 0x16,
    UNNECESSARY_AUTO_RECONNECTION: 0x17,
    DEVICE_SPECIAL_MODE: 0x18,
    PHONE_AND_CONNECTED_DEVICE_INFOMATION_FOR_CLASSIC: 0x19,
    TANDEM_RECONNECTION_REQUEST: 0x1A,
    DISPLAY_FW_VERSION: 0x1B,
    BATTERY_LEVEL_INDICATOR: 0x20,
    LEFT_RIGHT_BATTERY_LEVEL_INDICATOR: 0x21,
    CRADLE_BATTERY_LEVEL_INDICATOR: 0x22,
    POWER_OFF: 0x23,
    AUTO_POWER_OFF: 0x24,
    AUTO_POWER_OFF_WITH_WEARING_DETECTION: 0x25,
    POWER_SAVING_MODE_ON_OFF: 0x26,
    TANDEM_KEEP_ALIVE: 0x27,
    BATTERY_LEVEL_WITH_THRESHOLD: 0x28,
    LR_BATTERY_LEVEL_WITH_THRESHOLD: 0x29,
    CRADLE_BATTERY_LEVEL_WITH_THRESHOLD: 0x2A,
    BATTERY_SAFE_MODE: 0x2B,
    CARING_CHARGE: 0x2C,
    BT_STANDBY: 0x2D,
    STAMINA: 0x2E,
    AUTOMATIC_TOUCH_PANEL_BACKLIGHT_TURN_OFF: 0x2F,
    FW_UPDATE_MTK_TRANSFER_WITHOUT_DISCONNECTION: 0x32,
    FW_UPDATE_MTK_TRANSFER_WITHOUT_DISCONNECTION_AUTO_UPDATE: 0x34,
    FW_UPDATE_MTK_TRANSFER_WITH_REPAIR_MODE: 0x35,
    FW_UPDATE_MTK_TRANSFER_WITH_AC_CONNECTION_CHECK: 0x36,
    FW_UPDATE_TANDEM_TRANSFER_USING_COMMON_TABLE: 0x37,
    FW_UPDATE_USING_MC_APP: 0x38,
    TWS_SUPPORTS_A2DP_LEA_UNI_LEA_BROAD_WITH_CTKD: 0x40,
    HBS_SUPPORTS_A2DP_LEA_UNI_LEA_BROAD_WITH_CTKD: 0x41,
    CLASSIC_ONLY_LE_CLASSIC_SETTING: 0x42,
    TWS_SUPPORTS_LEA_UNI_LEA_BROAD: 0x43,
    CHANGE_TANDEM_CONNECTION_PROFILE_FOR_ANDROID: 0x44,
    BGM_MODE_CANT_BE_USED_WITH_LEA_CONNECTION: 0x45,
    HEAD_TRACKER_CANT_BE_USED_WITH_LEA_CONNECTION: 0x46,
    PAIRING_DEVICE_MANAGEMENT_CANT_BE_USED_WITH_LEA_CONNECTION: 0x47,
    SOUND_AR_CANT_BE_USED_WITH_LEA_CONNECTION: 0x48,
    AUTO_PLAY_CANT_BE_USED_WITH_LEA_CONNECTION: 0x49,
    GATT_CONNECTABLE_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4A,
    SOUND_AR_OPTIMIZATION_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4B,
    QUICK_ACCESS_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4C,
    CONNECTION_MODE_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4D,
    VOICE_ASSISTANT_SETTINGS_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4E,
    VOICE_ASSISTANT_WAKE_WORD_CANT_BE_USED_WITH_LEA_CONNECTION: 0x4F,
    PRESET_EQ: 0x50,
    EBB: 0x51,
    PRESET_EQ_NON_CUSTOMIZABLE: 0x52,
    PRESET_EQ_AND_ULT_MODE: 0x53,
    SOUND_EFFECT: 0x54,
    CUSTOM_EQ: 0x55,
    TURN_KEY_EQ: 0x56,
    PRESET_EQ_AND_ERRORCODE: 0x57,
    NOISE_CANCELLING_ONOFF: 0x61,
    NOISE_CANCELLING_ONOFF_AND_AMBIENT_SOUND_MODE_ONOFF: 0x62,
    NOISE_CANCELLING_DUAL_SINGLE_OFF_AND_AMBIENT_SOUND_MODE_ONOFF: 0x63,
    NOISE_CANCELLING_ONOFF_AND_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x64,
    NOISE_CANCELLING_DUAL_SINGLE_OFF_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x65,
    AMBIENT_SOUND_MODE_ONOFF: 0x66,
    AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x67,
    MODE_NC_ASM_NOISE_CANCELLING_DUAL_AUTO_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x68,
    AMBIENT_SOUND_CONTROL_MODE_SELECT: 0x69,
    MODE_NC_ASM_NOISE_CANCELLING_DUAL_SINGLE_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x6A,
    MODE_NC_ASM_NOISE_CANCELLING_DUAL_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT: 0x6B,
    MODE_NC_NCSS_ASM_NOISE_CANCELLING_DUAL_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT_WITH_TEST_MODE: 0x6C,
    MODE_NC_ASM_NOISE_CANCELLING_DUAL_AMBIENT_SOUND_MODE_LEVEL_ADJUSTMENT_NOISE_ADAPTATION: 0x6D,
    AUTO_NCASM: 0x70,
    ADAPTIVE_CONTROL_WITH_PARAMETER_NOTIFICATION: 0x71,
    NC_OPTIMIZER_PERSONAL_BAROMETRIC: 0x80,
    NC_OPTIMIZER_PERSONAL: 0x81,
    NC_OPTIMIZER_BAROMETRIC: 0x82,
    SOUND_FIELD_OPTIMIZATION: 0x83,
    TV_SOUND_BOOSTER: 0x84,
    FIXED_MESSAGE: 0x90,
    VIBRATOR_ALERT_NOTIFICATION: 0x91,
    FIXED_MESSAGE_WITH_LR_SELECTION: 0x92,
    VOICE_ASSISTANT_ALERT_NOTIFICATION: 0x93,
    LE_AUDIO_ALERT_NOTIFICATION: 0x94,
    PLAYBACK_CONTROLLER_WITH_CALL_VOLUME_ADJUSTMENT: 0xA1,
    PLAYBACK_CONTROLLER_WITH_CALL_VOLUME_ADJUSTMENT_AND_MUTE: 0xA2,
    PLAYBACK_CONTROLLER_WITH_CALL_VOLUME_ADJUSTMENT_AND_FUNCTION_CHANGE: 0xA3,
    PLAYBACK_CONTROLLER_WITH_FUNCTION_CHANGE: 0xA4,
    SAR: 0xB0,
    AUTO_PLAY: 0xB1,
    GATT_CONNECTABLE: 0xB2,
    SAR_OPTIMIZATION_COMPASS_ACCEL_TYPE: 0xB3,
    HEAD_TRACKER_COMPASS_ACCEL_TYPE: 0xB5,
    SAR_OPTIMIZATION_ACCEL_TYPE: 0xB6,
    HEAD_TRACKER_ACCEL_TYPE: 0xB7,
    INTEGRATED_AUTO_PLAY: 0xB8,
    ACTION_LOG_NOTIFIER: 0xC1,
    TIME_SERIES_OPERATIONLOG_NOTIFIER: 0xC2,
    SOUND_DROPOUT_NOTIFIER: 0xC3,
    GENERAL_SETTING_1: 0xD1,
    GENERAL_SETTING_2: 0xD2,
    GENERAL_SETTING_3: 0xD3,
    GENERAL_SETTING_4: 0xD4,
    CONNECTION_MODE_SOUND_QUALITY_CONNECTION_QUALITY: 0xE1,
    UPSCALING_AUTO_OFF: 0xE2,
    CONNECTION_MODE_SOUND_QUALITY_SOUND_WITH_LDAC_STATUS_QUALITY_CONNECTION_QUALITY: 0xE3,
    BGM_MODE_SMALL_MIDDLE_LARGE: 0xE4,
    UPMIX_CINEMA: 0xE5,
    LISTENING_OPTION: 0xE6,
    CONNECTION_MODE_CLASSIC_AUDIO_LE_AUDIO: 0xE7,
    VOICE_CONTENTS: 0xE8,
    SOUND_LEAKAGE_REDUCTION: 0xE9,
    LISTENING_OPTION_ASSIGN_CUSTOMIZABLE: 0xEA,
    BGM_MODE_SMALL_MIDDLE_LARGE_AND_ERRORCODE: 0xEB,
    UPMIX_SERIES: 0xEC,
    VIBRATOR_ON_OFF: 0xF0,
    PLAYBACK_CONTROL_BY_WEARING_REMOVING_HEADPHONE_ON_OFF: 0xF1,
    SMART_TALKING_MODE_TYPE1: 0xF2,
    ASSIGNABLE_SETTING: 0xF3,
    VOICE_ASSISTANT_SETTINGS: 0xF4,
    VOICE_ASSISTANT_WAKE_WORD_ON_OFF: 0xF5,
    WEARING_STATUS_DETECTOR: 0xF6,
    EARPIECE_SELECTION: 0xF7,
    CALL_SETTINGS: 0xF8,
    RESET_SETTINGS: 0xF9,
    AUTO_VOLUME: 0xFA,
    FACE_TAP_TEST_MODE: 0xFB,
    SMART_TALKING_MODE_TYPE2: 0xFC,
    QUICK_ACCESS: 0xFD,
    ASSIGNABLE_SETTING_WITH_LIMITATION: 0xFE,
    HEAD_GESTURE_ON_OFF_TRAINING: 0xFF,
};

