import Gio from 'gi://Gio';
import Gtk from 'gi://Gtk';
import Gdk from 'gi://Gdk';
import Adw from 'gi://Adw';

import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';


export default class BottomDashPanelPreferences extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        window._settings = this.getSettings();

        const page = new Adw.PreferencesPage({
            title: 'Bottom Dash Panel extension',
            icon_name: 'dialog-information-symbolic',
        });
        window.add(page);


        const group1 = new Adw.PreferencesGroup();
        page.add(group1);

        const multiMonitor = new Adw.SwitchRow({
            title: 'Bottom panel on all monitors',
        });
        group1.add(multiMonitor);
        window._settings.bind('multi-monitor', multiMonitor, 'active', Gio.SettingsBindFlags.DEFAULT);

        const togglePanel = new Adw.SwitchRow({
            title: 'Bottom pressure toggles bottom panel',
            subtitle: 'Dock mode or simply bottom panel toggle.',
        });
        group1.add(togglePanel);
        window._settings.bind('toggle-panel', togglePanel, 'active', Gio.SettingsBindFlags.DEFAULT);

        const overlapWindows = new Adw.SwitchRow({
            title: 'Bottom panel overlaps windows',
            subtitle: 'Classical dock behaviour.',
        });
        group1.add(overlapWindows);
        window._settings.bind('overlap-windows', overlapWindows, 'active', Gio.SettingsBindFlags.DEFAULT);

        const autoHide = new Adw.SwitchRow({
            title: 'Auto-hide bottom panel',
            subtitle: 'There is no intellihide here.',
        });
        group1.add(autoHide);
        window._settings.bind('auto-hide', autoHide, 'active', Gio.SettingsBindFlags.DEFAULT);

        const hideTopPanel = new Adw.SwitchRow({
            title: 'Hide top panel',
            subtitle: 'Top panel appears only in overview.',
        });
        group1.add(hideTopPanel);
        window._settings.bind('hide-top-panel', hideTopPanel, 'active', Gio.SettingsBindFlags.DEFAULT);

        const noOverview = new Adw.SwitchRow({
            title: 'No overview at start-up',
        });
        group1.add(noOverview);
        window._settings.bind('no-overview', noOverview, 'active', Gio.SettingsBindFlags.DEFAULT);


        const group2 = new Adw.PreferencesGroup();
        page.add(group2);

        const panelMode = new Adw.SwitchRow({
            title: 'Full-width dash',
            subtitle: 'Panel mode.',
        });
        group2.add(panelMode);
        window._settings.bind('panel-mode', panelMode, 'active', Gio.SettingsBindFlags.DEFAULT);

        const adjustmentDashHeight = new Gtk.Adjustment({
            lower: 1,
            upper: 15,
            step_increment: 0.1,
            page_increment: 1.0,
        });

        const dashHeight = new Adw.SpinRow({
            title: 'Dash max height (% of monitor height)',
            subtitle: 'GNOME dash has fixed icon sizes (16, 22, 24, 32, 48, 64).\nActual dash height can be less than this maximum.',
            adjustment: adjustmentDashHeight,
            digits: 1,
        });
        group2.add(dashHeight);
        window._settings.bind('dash-height', dashHeight, 'value', Gio.SettingsBindFlags.DEFAULT);

        const accentColor = new Adw.SwitchRow({
            title: 'Dash background uses accent color',
            subtitle: 'Overrides the next item color.',
        });
        group2.add(accentColor);
        window._settings.bind('accent-color', accentColor, 'active', Gio.SettingsBindFlags.DEFAULT);

        const dashBackgroundColor = new Adw.ActionRow({
            title: 'Dash background color',
        });
        group2.add(dashBackgroundColor);

        const colorButton = new Gtk.ColorButton({
            valign: Gtk.Align.CENTER,
            use_alpha: true,
        });

        const colorString = window._settings.get_string('background-color');
        const rgba = new Gdk.RGBA();
        rgba.parse(colorString);
        colorButton.set_rgba(rgba);

        colorButton.connect('color-set', () => {
            const newColor = colorButton.get_rgba();
            const colorString = `rgba(${Math.round(newColor.red * 255)},${Math.round(newColor.green * 255)},${Math.round(newColor.blue * 255)},${newColor.alpha})`;
            window._settings.set_string('background-color', colorString);
        });

        dashBackgroundColor.add_suffix(colorButton);
        dashBackgroundColor.activatable_widget = colorButton;

        const syncColor = new Adw.SwitchRow({
            title: 'Apply dash color to top panel',
        });
        group2.add(syncColor);
        window._settings.bind('sync-color', syncColor, 'active', Gio.SettingsBindFlags.DEFAULT);

        const adjustmentAnimationTime = new Gtk.Adjustment({
            lower: 0,
            upper: 500,
            step_increment: 50,
        });

        const animationTime = new Adw.SpinRow({
            title: 'Dash hide/show animation time (ms)',
            adjustment: adjustmentAnimationTime,
        });
        group2.add(animationTime);
        window._settings.bind('animation-time', animationTime, 'value', Gio.SettingsBindFlags.DEFAULT);

        const adjustmentBottomPressure = new Gtk.Adjustment({
            lower: 0,
            upper: 500,
            step_increment: 50,
        });

        const bottomPressure = new Adw.SpinRow({
            title: 'Bottom edge pressure (px)',
            subtitle: '0 means no pressure.',
            adjustment: adjustmentBottomPressure,
        });
        group2.add(bottomPressure);
        window._settings.bind('bottom-pressure', bottomPressure, 'value', Gio.SettingsBindFlags.DEFAULT);
    }
}
