# Quran Radio - GNOME Shell Extension

A beautiful GNOME Shell extension for listening to live Qur'an radio streams with an Arabic RTL interface.

![License](https://img.shields.io/badge/license-MIT-blue.svg)
![GNOME Version](https://img.shields.io/badge/GNOME-45%2B-green.svg)
![Language](https://img.shields.io/badge/language-JavaScript-yellow.svg)

## Features

- 🎵 **140+ Radio Stations** - Access to Qurango.net's collection of Qur'an recitations
- 🌍 **Bilingual Support** - Full Arabic and English interface with RTL support
- 🔍 **Search & Filter** - Search stations by name and filter by 18 different categories
- ❤️ **Favorites** - Save your favorite stations for quick access
- 🎚️ **Volume Control** - Built-in volume slider with persistence
- 🔄 **Auto-Reconnect** - Automatically reconnects on connection drops
- 🌙 **Arabic RTL Interface** - Fully localized Arabic interface with right-to-left layout
- 💾 **State Persistence** - Remembers last station, volume, favorites, and selected category
- 🎨 **Modern Dark Theme** - Beautiful dark UI matching GNOME's aesthetic

## Categories Available

1. **المفضلة** (Favorites)
2. **الكل** (All)
3. **قرآن** (Quran Recitations)
4. **تفسير** (Tafsir/Interpretation)
5. **فتاوى** (Fatwa/Religious Rulings)
6. **منوعات** (Miscellaneous)
7. **ترجمات** (Translations)
8. **أذكار** (Athkar/Remembrance)
9. **رقية شرعية** (Ruqyah/Legal Incantation)
10. **الحديث** (Hadith)
11. **السيرة النبوية** (Prophet's Biography)
12. **سيرة الصحابة** (Companions' Biography)
13. **رواية ورش عن نافع** (Warsh narration)
14. **رواية قالون عن نافع** (Qalun narration)
15. **رواية الدوري عن أبي عمرو** (Al-Duri narration)
16. **رواية السوسي عن أبي عمرو** (Al-Susi narration)
17. **روايات أخرى** (Other Narrations)

## Requirements

- GNOME Shell 45, 46, or 47
- GStreamer (for audio playback)
- JavaScript (ES Modules)
- Wayland or X11

## Installation

### Method 1: Manual Installation

```bash
# Clone or download the extension
mkdir -p ~/.local/share/gnome-shell/extensions/quran-radio@Alkacem

# Copy all files to the extension directory
cp -r * ~/.local/share/gnome-shell/extensions/quran-radio@Alkacem/

# Compile GSettings schema
glib-compile-schemas ~/.local/share/gnome-shell/extensions/quran-radio@Alkacem/schemas/

# Enable the extension
gnome-extensions enable quran-radio@Alkacem
```

### Method 2: From Desktop Folder

If you have the extension in `~/Desktop/gnomeExtention/`:

```bash
# Copy to GNOME extensions folder
cp -r ~/Desktop/gnomeExtention/* ~/.local/share/gnome-shell/extensions/quran-radio@local/

# Compile schemas
glib-compile-schemas ~/.local/share/gnome-shell/extensions/quran-radio@local/schemas/

# Enable
gnome-extensions enable quran-radio@local
```

### Restart GNOME Shell

After installation, restart GNOME Shell:
- **Wayland**: Log out and log back in
- **X11**: Press `Alt+F2`, type `r`, then press Enter

## Usage

1. **Open the Menu**: Click the radio icon in the GNOME top panel
2. **Play a Station**: Click the play button next to any station name
3. **Control Playback**: Use the top play/pause button to control playback
4. **Adjust Volume**: Drag the volume slider to your preferred level
5. **Search**: Type in the search box to find specific stations
6. **Filter by Category**: Click category tags to filter stations
7. **Add to Favorites**: Click the heart icon next to any station
8. **Change Language**: Click the language dropdown (العربية/English) to switch between Arabic and English

### Keyboard Shortcuts

- Click the panel icon to open/close the dropdown menu
- The extension supports GNOME's built-in accessibility features

## File Structure

```
quran-radio@Alkacem/
├── extension.js          # Main extension logic and UI
├── metadata.json         # Extension metadata
├── player.js             # GStreamer audio player
├── stations.js           # Radio stations data (140+ stations)
├── stylesheet.css        # UI styling (RTL Arabic)
├── LICENSE               # MIT License
└── schemas/
    ├── org.gnome.shell.extensions.quran-radio.gschema.xml
    └── gschemas.compiled
```

## Configuration

The extension uses GSettings for persistence. You can modify settings using `gsettings`:

```bash
# View all settings
gsettings list-keys org.gnome.shell.extensions.quran-radio

# Get current volume
gsettings get org.gnome.shell.extensions.quran-radio volume

# Set volume (0.0 to 1.0)
gsettings set org.gnome.shell.extensions.quran-radio volume 0.8

# Get favorites list
gsettings get org.gnome.shell.extensions.quran-radio favorites

# Get last played station
gsettings get org.gnome.shell.extensions.quran-radio last-station

# Get selected category
gsettings get org.gnome.shell.extensions.quran-radio selected-category

# Enable/disable notifications
gsettings set org.gnome.shell.extensions.quran-radio show-notifications true

# Enable/disable auto-start on login
gsettings set org.gnome.shell.extensions.quran-radio autostart false
```

## Technical Details

### Audio Engine
- Uses **GStreamer** for audio streaming
- Supports MP3 and AAC formats
- Auto-reconnect on connection drops
- Buffer management for smooth playback

### UI Components
- **PanelMenu.Button**: Top panel indicator
- **PopupMenu**: Dropdown interface
- **St.Widget**: GNOME Shell widgets
- **Custom CSS**: RTL Arabic styling with dark theme

### Data Source
- Stations data sourced from Qurango.net API
- 140+ radio stations across multiple categories
- Direct streaming URLs from backup.qurango.net

## Troubleshooting

### Extension Not Showing
```bash
# Check if extension is enabled
gnome-extensions show quran-radio@Alkacem

# Enable if disabled
gnome-extensions enable quran-radio@Alkacem
```

### No Sound
- Check system volume
- Verify GStreamer is installed: `gst-inspect-1.0 playbin`
- Check if the station URL is accessible

### Schema Errors
```bash
# Recompile schemas
glib-compile-schemas ~/.local/share/gnome-shell/extensions/quran-radio@Alkacem/schemas/

# Reset settings
gsettings reset-recursively org.gnome.shell.extensions.quran-radio
```

### Debug Mode
View extension logs:
```bash
# Monitor logs in real-time
journalctl -f -o cat | grep -i quran

# Or use GNOME Logs application
```

## Development

### Project Files

- **extension.js**: Main extension class, builds the UI
- **player.js**: Audio player using GStreamer
- **stations.js**: Static data for all radio stations
- **stylesheet.css**: Styling with RTL support

### Adding New Stations

Edit `stations.js` and add a new object to the `STATIONS` array:

```javascript
{
  id: 'unique-id',
  name: 'إذاعة القارئ الجديد',
  category: ['قرآن'],
  url: 'https://backup.qurango.net/radio/station_name'
}
```

### Adding New Categories

Edit `stations.js` and add to the `CATEGORIES` array:

```javascript
export const CATEGORIES = [
  'المفضلة',
  'الكل',
  'قرآن',
  'تفسير',
  // ... add your new category here
];
```

## License

This project is open source. Feel free to modify and distribute.

## Credits

- **Audio Source**: Qurango.net - Providing Qur'an radio streams
- **GNOME Team**: For the GNOME Shell extension framework
- **Contributors**: All contributors to this project

## Support

For issues, suggestions, or contributions:
- GitHub: https://github.com/dhiflaoui/gnome_quran_radio
- Email: your-email@example.com

---

**Made with ❤️ for the Muslim Ummah**

*اللهم ارحمنا بالقرآن*
