import * as Keyboard from 'resource:///org/gnome/shell/ui/keyboard.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import ExtensionFeature from '../../core/extensionFeature.js';
import { settings } from '../../settings.js';
import { OSKKeyPopupFeature } from './_oskKeyPopupsFeature.js';
import { OSKGesturesFeature } from './_oskGesturesFeature.js';

//@ts-ignore
class OskFeature extends ExtensionFeature {
    constructor(pm) {
        super(pm);
        this.defineSubFeature({
            name: 'osk-key-popups',
            create: (pm) => new OSKKeyPopupFeature(pm, Main.keyboard._keyboard),
            setting: settings.osk.keyPopups.enabled,
        });
        this.defineSubFeature({
            name: 'osk-gestures',
            create: (pm) => new OSKGesturesFeature(pm, Main.keyboard._keyboard),
        });
        // When the keyboard is replaced/a new keyboard is created, notify all sub-features:
        const self = this;
        this.pm.appendToMethod(Keyboard.Keyboard.prototype, '_init', function () {
            self.getSubFeature(OSKKeyPopupFeature)?.onNewKeyboard(this);
            self.getSubFeature(OSKGesturesFeature)?.onNewKeyboard(this);
        });
    }
}

export { OskFeature };
