#!/usr/bin/env gjs

const {GLib, Gio} = imports.gi;

const currentPath = GLib.path_get_dirname(new Error().fileName);
imports.searchPath.unshift(currentPath);

const {dbusUtils: DBusUtils} = imports;
const {logger: Logger} = imports;
const {promiseUtils: PromiseUtils} = imports;

const DEFAULT_ITEM_OBJECT_PATH = '/StatusNotifierItem';

async function _seekStatusNotifierItems() {
    // Some indicators (*coff*, dropbox, *coff*) do not re-register again
    // when the plugin is enabled/disabled, thus we need to manually look
    // for the objects in the session bus that implements the
    // StatusNotifierItem interface... However let's do it after a low
    // priority idle, so that it won't affect startup.
    const cancellable = null;
    print('Waiting for idle...');
    await new PromiseUtils.IdlePromise(GLib.PRIORITY_LOW, cancellable);
    print('Idle done');
    const bus = Gio.DBus.session;
    print('Getting bus names');
    const uniqueNames = await DBusUtils.getBusNames(bus, cancellable);
    print('Got names!');


    // uniqueNames.forEach();

    // const introspectName = async name => {
    //     try {
    //     const nodes = await DBusUtils.introspectBusObject(bus, name, cancellable,
    //         ['org.kde.StatusNotifierItem']);
    //     const services = [...uniqueNames.get(name)];
    //     nodes.forEach(({ nodeInfo, path }) => {
    //         if (DBusUtils.dbusNodeImplementsInterfaces(nodeInfo, ['org.kde.StatusNotifierItem'])) {
    //             const ids = services.map(s => DBusUtils.indicatorId(s, name, path));
    //             const service = services.find(s =>
    //                 s && s.startsWith('org.kde.StatusNotifierItem')) || services[0];
    //             const id = DBusUtils.indicatorId(
    //                 path === DEFAULT_ITEM_OBJECT_PATH ? service : null,
    //                 name, path);
    //             print('Found', id, 'name',name, 'path', path)
    //             Logger.warn(`Using Brute-force mode for StatusNotifierItem ${id}`);
    //         }
    //     });
    // } catch(e) {
    //     // logError(e);
    // }
    // };
    // await Promise.allSettled([...uniqueNames.keys()].map(n => introspectName(n)));


    // async function *introspectName(name) {
    //     yield DBusUtils.introspectBusObject(bus, name, cancellable,
    //         ['org.kde.StatusNotifierItem']);
    // }

    await Promise.allSettled([...uniqueNames.keys()].map(async name => {
        try {
            for await (const node of DBusUtils.introspectBusObject(bus, name, cancellable,
                ['org.kde.StatusNotifierItem'])) {
                const services = [...uniqueNames.get(name)];

                const {nodeInfo, path} = node;
                if (DBusUtils.dbusNodeImplementsInterfaces(nodeInfo, ['org.kde.StatusNotifierItem'])) {
                    const ids = services.map(s => DBusUtils.indicatorId(s, name, path));
                    const service = services.find(s =>
                        s && s.startsWith('org.kde.StatusNotifierItem')) || services[0];
                    const id = DBusUtils.indicatorId(
                        path === DEFAULT_ITEM_OBJECT_PATH ? service : null,
                        name, path);
                    print('Found', id, 'name', name, 'path', path);
                    Logger.warn(`Using Brute-force mode for StatusNotifierItem ${id}`);
                }
            }
        } catch (e) {
            logError(e);
        }
    }));
}

function main(_argv) {
    const loop = new GLib.MainLoop(null, false);
    let i = 0;
    let pre = GLib.get_monotonic_time();
    const id = GLib.timeout_add(GLib.PRIORITY_DEFAULT, 16, () => {
        const now = GLib.get_monotonic_time();
        const diff = (now - pre) / 1000.0;
        print('tick', i++, 'diff', diff, diff > 30 ? 'WARN!!!' : '');
        // if (diff > 30)
        //     logError(new Error());
        pre = now;
        return true;
    });

    _seekStatusNotifierItems().catch(logError).finally(() => {
        GLib.source_remove(id);
        loop.quit();
    });
    loop.run();
}

main(ARGV);
