#!/usr/bin/env gjs

const {GLib, Gio} = imports.gi;
const ByteArray = imports.byteArray;
import GdkPixbuf from 'gi://GdkPixbuf';

Gio._promisify(Gio.Subprocess.prototype, 'wait_check_async', 'wait_check_finish');
Gio._promisify(Gio.Subprocess.prototype, 'communicate_async', 'communicate_finish');
Gio._promisify(Gio.InputStream.prototype, 'read_bytes_async', 'read_bytes_finish');
Gio._promisify(Gio.InputStream.prototype, 'read_all_async', 'read_all_finish');
Gio._promisify(GdkPixbuf.Pixbuf, 'new_from_stream_async', 'new_from_stream_finish');

async function* createAsyncIterator(stream, count, ioPriority = GLib.PRIORITY_DEFAULT) {
    const self = stream;

    function next() {
        return new Promise((resolve, reject) => {
            self.read_bytes_async(count, ioPriority, null, (_self, res) => {
                try {
                    const bytes = self.read_bytes_finish(res);
                    resolve(bytes);
                } catch (err) {
                    reject(err);
                }
            });
        });
    }

    while (true) {
        // eslint-disable-next-line no-await-in-loop
        const bytes = await next(count);
        if (bytes.get_size() === 0)
            return;
        yield bytes;
    }
}


async function main(argv) {
    if (argv.length < 4) {
        printerr('Usage: rgbaReader.js bus-name path property preferred-size');
        return 1;
    }

    // argbToRgba-tool.js

    const [busName, path, property, preferredSize] = argv;
    const cancellable = null;

    const callArgs = ['gjs', 'argbToRgba-tool.js', busName, path, property, preferredSize, '1'];
    const subProcess = Gio.Subprocess.new(
        callArgs,
        Gio.SubprocessFlags.STDOUT_PIPE | Gio.SubprocessFlags.STDERR_PIPE);

    print('Calling', callArgs.join(' '));

    let communication;

    // do {
    //     try {
    //         [communication] = await subProcess.communicate_async(null, cancellable);
    //         print('communication', communication, communication ? communication.get_size() : -1);
    //     } catch (e) {
    //         if (e.matches())
    //     }
    // } while (communication);

    const [stdOut, stdErr] = await subProcess.communicate_async(null, cancellable);
    print('communication', stdOut, stdOut ? stdOut.get_size() : -1);
    const controlBytes = stdErr.get_data();
    const stdoutBytes = stdOut.get_data();

    await subProcess.wait_check_async(cancellable);
    print('Call done, byes size', stdoutBytes.length);

    // const imageData = stdoutBytes.slice(16, stdoutBytes.length - 16);
    // print('ImageData', imageData.length);

    let currentIndex = 0;
    const getInfoValue =  size => {
        const startIndex = currentIndex;
        currentIndex += size;

        return Number(ByteArray.toString(
            controlBytes.slice(startIndex, currentIndex)));
    };

    const iconDataSize = getInfoValue(8);
    const width = getInfoValue(4);
    const height = getInfoValue(4);
    // const iconData = stdoutBytes.slice(currentIndex);

    print('iconDataSize', iconDataSize);
    print('width', width);
    print('height', height);

    print('bytes', stdoutBytes.slice(currentIndex).length);

    if (iconData.length !== iconDataSize)
        throw new Error(`Unexpected data size: ${iconData.length} of expected ${iconDataSize}`);

    // const outputStream = new Gio.UnixOutputStream({fd: 1, closeFd: true});
    // outputStream.write_bytes(stdoutBytes.slice(currentIndex), cancellable);
    // print('rowStride', rowStride);

    // const bytes = await subProcess.get_stdout_pipe().read_bytes_async(
    //     iconDataSize, GLib.PRIORITY_DEFAULT, cancellable);
    // print('Read bytes', bytes, bytes.get_size());
    // const pixbuf = await GdkPixbuf.Pixbuf.new_from_stream_async(subProcess.get_stdout_pipe(), cancellable);
    // print('Pixbuf', pixbuf);


    // const cancellable = null;

    // const connection = Gio.bus_get_sync(Gio.BusType.SESSION, cancellable);
    // const [pixmapsVariant] = connection.call_sync(busName, path,
    //     'org.freedesktop.DBus.Properties', 'Get',
    //     new GLib.Variant('(ss)', ['org.kde.StatusNotifierItem', property]),
    //     null, Gio.DBusCallFlags.NO_AUTO_START, -1, cancellable).deep_unpack();

    // const pixmapsArray = pixmapsVariant.deep_unpack();

    // if (!pixmapsArray || pixmapsArray.length < 1)
    //     throw TypeError('Empty Icon found');

    // const sortedPixmapsArray = pixmapsArray.sort((pixmapA, pixmapB) => {
    //     // we sort smallest to biggest
    //     const areaA = pixmapA[0] * pixmapA[1];
    //     const areaB = pixmapB[0] * pixmapB[1];

    //     return areaA - areaB;
    // });

    // const qualifiedPixmapArray = sortedPixmapsArray.filter(([width, height]) =>
    //     // we prefer any pixmap that is equal or bigger than our requested size
    //     width >= preferredSize && height >= preferredSize);

    // const iconPixmap = qualifiedPixmapArray.length > 0
    //     ? qualifiedPixmapArray[0] : sortedPixmapsArray.pop();

    // const [width, height, bytes] = iconPixmap;
    // const rowStride = width * 4; // hopefully this is correct

    // // print(argbToRgba(bytes));

    // const outputStream = new Gio.UnixOutputStream({fd, closeFd: true});
    // outputStream.write_bytes(argbToRgba(bytes), cancellable);

    return 0;
}

main(ARGV).catch(logError);

const loop = new GLib.MainLoop(null, false);
loop.run();
