# Dual Monitor Toggle

Dual Monitor Toggle is a GNOME Shell extension that allows you to easily enable or disable your secondary monitor with a single click. It adds a toggle button to the system menu, providing a quick and convenient way to switch your second monitor on or off without needing to navigate through settings.

## Features

- Toggle your secondary monitor on or off with a single click
- Automatically detects connected monitors and their configurations
- Provides a visual indication of the current state of your secondary monitor
- Supports multiple monitor configurations
- Preserves monitor positions, scale, and arrangement on toggle
- Restores the original primary monitor when re-enabling
- Choose between Temporary (resets on reboot) and Persistent (survives reboot) configuration modes
- Optionally set a re-enabled monitor as primary
- Falls back to `~/.config/monitors.xml` when no runtime layout is available
- Optional structured debug logging for troubleshooting

## Installation

1. Download the latest release of the extension from the [GNOME Extensions website](https://extensions.gnome.org/extension/6898/dual-monitor-toggle/) or from the [GitHub releases page](https://github.com/poka-IT/gnome-dual-monitor-toggle/releases).
2. Extract the downloaded ZIP file to the GNOME Shell extensions directory:
   - For local user installation: `~/.local/share/gnome-shell/extensions/`
   - For system-wide installation: `/usr/share/gnome-shell/extensions/`
3. Log out and log back in, or restart GNOME Shell by pressing `Alt`+`F2`, typing `r`, and pressing `Enter`.
4. Enable the extension using the Extensions app or the `gnome-extensions` command.

## Usage

After installing and enabling the extension, you will see a new toggle button in the system menu, typically located in the top-right corner of your screen. Click on this button to toggle your secondary monitor on or off.

The extension automatically detects your connected monitors and their configurations. If you have multiple secondary monitors, you can select which one to control by clicking on the arrow next to the toggle button and choosing the desired monitor from the dropdown menu.

## Troubleshooting

If you encounter any issues with the extension, please try the following:

1. Make sure that your system meets the requirements for running GNOME Shell extensions.
2. Disable and re-enable the extension using the Extensions app or the `gnome-extensions` command.
3. Restart GNOME Shell by pressing `Alt`+`F2`, typing `r`, and pressing `Enter`.
4. Enable debug logging for detailed diagnostics:
   ```bash
   gsettings set org.gnome.shell.extensions.dual-monitor-toggle debug-logging true
   journalctl --user -f -o cat | grep DualMonitorToggle
   ```
5. If the issue persists, please open an issue on the [GitHub issue tracker](https://github.com/poka-IT/gnome-dual-monitor-toggle/issues) with a detailed description of the problem and any relevant error messages or debug logs.

## Contributing

Contributions to Dual Monitor Toggle are welcome! If you would like to contribute, please follow these steps:

1. Fork the repository on GitHub.
2. Create a new branch for your feature or bug fix.
3. Make your changes and commit them with descriptive commit messages.
4. Push your changes to your fork.
5. Submit a pull request to the main repository.

Please ensure that your code follows the existing style and conventions, and that you have tested your changes thoroughly before submitting a pull request.

## License

Dual Monitor Toggle is released under the [GPL-3.0 License](LICENSE).
