import Adw from 'gi://Adw';
import Gtk from 'gi://Gtk';
import Gio from 'gi://Gio';

import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';

export default class DevSentryPreferences extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        const settings = this.getSettings();

        window.set_title('Dev Sentry');
        window.set_default_size(600, 450);
        window.search_enabled = false;

        const page = new Adw.PreferencesPage({
            title: 'Settings',
            icon_name: 'preferences-system-symbolic',
        });
        window.add(page);

        const pathGroup = new Adw.PreferencesGroup({
            title: 'Active Project',
            description: 'Dev Sentry will only show errors from this folder. Leave empty to monitor all GNOME Shell errors.',
        });
        page.add(pathGroup);

        const pathRow = new Adw.ActionRow({
            title: 'Project Folder',
            subtitle: 'Select your extension development folder',
            activatable: false,
        });

        const pathEntry = new Gtk.Entry({
            placeholder_text: '/home/user/.local/share/gnome-shell/extensions/my-extension@user',
            valign: Gtk.Align.CENTER,
            hexpand: true,
            width_chars: 30,
        });
        settings.bind('project-path', pathEntry, 'text', Gio.SettingsBindFlags.DEFAULT);

        const browseBtn = new Gtk.Button({
            icon_name: 'folder-open-symbolic',
            valign: Gtk.Align.CENTER,
            tooltip_text: 'Browse folder',
            css_classes: ['flat'],
        });
        browseBtn.connect('clicked', () => this._openFolderDialog(pathEntry, window));

        const clearBtn = new Gtk.Button({
            icon_name: 'edit-clear-symbolic',
            valign: Gtk.Align.CENTER,
            tooltip_text: 'Clear path',
            css_classes: ['flat', 'destructive-action'],
        });
        clearBtn.connect('clicked', () => settings.set_string('project-path', ''));

        pathRow.add_suffix(pathEntry);
        pathRow.add_suffix(browseBtn);
        pathRow.add_suffix(clearBtn);
        pathGroup.add(pathRow);

        const statusRow = new Adw.ActionRow({ title: 'Active Filter' });

        const statusLabel = new Gtk.Label({
            valign: Gtk.Align.CENTER,
            css_classes: ['dim-label'],
            ellipsize: 3,
            max_width_chars: 40,
        });

        const updateStatus = () => {
            let path = settings.get_string('project-path');
            if (path.trim()) {
                let uuid = path.replace(/\/+$/, '').split('/').pop();
                statusLabel.label = uuid;
                statusLabel.css_classes = ['success'];
            } else {
                statusLabel.label = 'Monitoring all errors (Filter OFF)';
                statusLabel.css_classes = ['dim-label'];
            }
        };
        updateStatus();
        settings.connect('changed::project-path', updateStatus);

        statusRow.add_suffix(statusLabel);
        pathGroup.add(statusRow);

        const behaviorGroup = new Adw.PreferencesGroup({ title: 'Behavior' });
        page.add(behaviorGroup);

        const notifRow = new Adw.ActionRow({
            title: 'Show Notifications',
            subtitle: 'Show toasts when copying logs or launching tools',
        });
        
        const notifSwitch = new Gtk.Switch({
            valign: Gtk.Align.CENTER,
        });
        settings.bind('show-notifications', notifSwitch, 'active', Gio.SettingsBindFlags.DEFAULT);
        
        notifRow.add_suffix(notifSwitch);
        behaviorGroup.add(notifRow);

        const aboutGroup = new Adw.PreferencesGroup({ title: 'ℹ️ About Dev Sentry' });
        page.add(aboutGroup);

        const infoRows = [
            { title: 'Error Types',   subtitle: '🔴 JS Error  •  🟠 Gjs-Critical  •  🟢 Fix (Source)  •  🔵 Stack Trace' },
            { title: 'Click to Open', subtitle: 'Clicking a "Fix" or Error line opens VS Code directly at that line.' },
            { title: 'Fetch Logs',    subtitle: 'Use the Refresh button to fetch new logs if the stream stops.' },
        ];
        for (let info of infoRows) {
            aboutGroup.add(new Adw.ActionRow({ title: info.title, subtitle: info.subtitle }));
        }
    }

    _openFolderDialog(entry, window) {
        const dialog = new Gtk.FileDialog({ title: 'Select Project Folder', modal: true });
        dialog.select_folder(window, null, (dlg, res) => {
            try {
                const file = dlg.select_folder_finish(res);
                if (file) entry.text = file.get_path();
            } catch (_) {}
        });
    }
}