import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';
import Adw from 'gi://Adw';
import Gtk from 'gi://Gtk';

export default class RelojLCDPreferences extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        const settings = this.getSettings();
        const page = new Adw.PreferencesPage();
        const displayGroup = new Adw.PreferencesGroup({ title: 'LCD Display Settings' });
        page.add(displayGroup);

        const formatRow = new Adw.ActionRow({ title: '24-Hour Format' });
        const formatSwitch = new Gtk.Switch({
            active: settings.get_boolean('clock-format-24h'),
                                            valign: Gtk.Align.CENTER
        });
        formatSwitch.connect('notify::active', (w) => settings.set_boolean('clock-format-24h', w.active));
        formatRow.add_suffix(formatSwitch);
        displayGroup.add(formatRow);

        const secondsRow = new Adw.ActionRow({ title: 'Show Seconds' });
        const secondsSwitch = new Gtk.Switch({
            active: settings.get_boolean('show-seconds'),
                                             valign: Gtk.Align.CENTER
        });
        secondsSwitch.connect('notify::active', (w) => settings.set_boolean('show-seconds', w.active));
        secondsRow.add_suffix(secondsSwitch);
        displayGroup.add(secondsRow);

        const blinkRow = new Adw.ActionRow({ title: 'Blinking Separators' });
        const blinkSwitch = new Gtk.Switch({
            active: settings.get_boolean('blink-dots'),
                                           valign: Gtk.Align.CENTER
        });
        blinkSwitch.connect('notify::active', (w) => settings.set_boolean('blink-dots', w.active));
        blinkRow.add_suffix(blinkSwitch);
        displayGroup.add(blinkRow);

        const fontRow = new Adw.ActionRow({ title: 'Font Size (em)' });
        const fontSpin = new Gtk.SpinButton({
            adjustment: new Gtk.Adjustment({ lower: 1.0, upper: 5.0, step_increment: 0.1, value: settings.get_double('font-size') }),
                                            digits: 1,
                                            valign: Gtk.Align.CENTER
        });
        fontSpin.connect('value-changed', (w) => settings.set_double('font-size', w.get_value()));
        fontRow.add_suffix(fontSpin);
        displayGroup.add(fontRow);

        const glowRow = new Adw.ActionRow({ title: 'Glow Intensity' });
        const glowSpin = new Gtk.SpinButton({
            adjustment: new Gtk.Adjustment({ lower: 0.0, upper: 20.0, step_increment: 1.0, value: settings.get_double('glow-intensity') }),
                                            digits: 0,
                                            valign: Gtk.Align.CENTER
        });
        glowSpin.connect('value-changed', (w) => settings.set_double('glow-intensity', w.get_value()));
        glowRow.add_suffix(glowSpin);
        displayGroup.add(glowRow);

        const colorRow = new Adw.ActionRow({ title: 'Clock Color' });
        const colorOptions = ['Neon Green', 'Vintage Amber', 'Retro Gray'];
        const colorValues = ['green', 'amber', 'gray'];
        const colorCombo = new Gtk.DropDown({
            model: Gtk.StringList.new(colorOptions),
                                            selected: colorValues.indexOf(settings.get_string('clock-color')),
                                            valign: Gtk.Align.CENTER
        });
        const updateGlowLabel = (val) => {
            glowRow.set_title(val === 'gray' ? 'LCD Shadow Depth' : 'Glow Intensity');
        };
        colorCombo.connect('notify::selected', (w) => {
            const val = colorValues[w.selected];
            settings.set_string('clock-color', val);
            updateGlowLabel(val);
        });
        updateGlowLabel(colorValues[colorCombo.selected]);
        colorRow.add_suffix(colorCombo);
        displayGroup.add(colorRow);

        const posGroup = new Adw.PreferencesGroup({ title: 'Panel Position' });
        page.add(posGroup);
        const posRow = new Adw.ActionRow({ title: 'Alignment' });
        const posOptions = ['Left', 'Center', 'Right'];
        const posValues = ['left', 'center', 'right'];
        const posCombo = new Gtk.DropDown({
            model: Gtk.StringList.new(posOptions),
                                          selected: posValues.indexOf(settings.get_string('panel-position')),
                                          valign: Gtk.Align.CENTER
        });
        posCombo.connect('notify::selected', (w) => settings.set_string('panel-position', posValues[w.selected]));
        posRow.add_suffix(posCombo);
        posGroup.add(posRow);

        const alarmGroup = new Adw.PreferencesGroup({ title: 'Alarm Settings' });
        page.add(alarmGroup);
        const alarmEnRow = new Adw.ActionRow({ title: 'Enable Alarm' });
        const alarmEnSwitch = new Gtk.Switch({
            active: settings.get_boolean('alarm-enabled'),
                                             valign: Gtk.Align.CENTER
        });
        alarmEnSwitch.connect('notify::active', (w) => settings.set_boolean('alarm-enabled', w.active));
        alarmEnRow.add_suffix(alarmEnSwitch);
        alarmGroup.add(alarmEnRow);

        const timeRow = new Adw.ActionRow({ title: 'Alarm Time' });
        const hourSpin = new Gtk.SpinButton({
            adjustment: new Gtk.Adjustment({ lower: 0, upper: 23, step_increment: 1, value: settings.get_int('alarm-hour') }),
                                            valign: Gtk.Align.CENTER
        });
        const minSpin = new Gtk.SpinButton({
            adjustment: new Gtk.Adjustment({ lower: 0, upper: 59, step_increment: 1, value: settings.get_int('alarm-minute') }),
                                           valign: Gtk.Align.CENTER
        });
        hourSpin.connect('value-changed', (w) => settings.set_int('alarm-hour', w.get_value()));
        minSpin.connect('value-changed', (w) => settings.set_int('alarm-minute', w.get_value()));
        timeRow.add_suffix(hourSpin);
        timeRow.add_suffix(new Gtk.Label({ label: ' : ' }));
        timeRow.add_suffix(minSpin);
        alarmGroup.add(timeRow);

        const msgRow = new Adw.EntryRow({
            title: 'Alarm Message',
            text: settings.get_string('alarm-message')
        });
        msgRow.connect('changed', (w) => settings.set_string('alarm-message', w.get_text()));
        alarmGroup.add(msgRow);

        window.add(page);
    }
}
