import { Extension } from 'resource:///org/gnome/shell/extensions/extension.js';
import * as Main from 'resource:///org/gnome/shell/ui/main.js';
import St from 'gi://St';
import Shell from 'gi://Shell';
import GLib from 'gi://GLib';

export default class IconAreaHorizontalSpacing extends Extension {
    enable() {
        this._settings = this.getSettings();
        this._styleLine = '';
        this._actorAddedID = 0;

        this._applyStyles();

        // Écoute les changements de paramètres
        this._hpaddingChangedID = this._settings.connect('changed::hpadding', () => {
            this._removeStyles();
            this._applyStyles();
        });
    }

    disable() {
        this._removeStyles();

        if (this._hpaddingChangedID) {
            this._settings.disconnect(this._hpaddingChangedID);
            this._hpaddingChangedID = 0;
        }
        
        this._settings = null;
    }

    _overrideStyle(actor, secondTime = false) {
        // Dans les versions récentes, on vérifie si l'acteur est un panel-button
        // ou s'il contient un descendant qui l'est.
        if (!actor || !actor.has_style_class_name) return;

        if (!actor.has_style_class_name('panel-button')) {
            if (secondTime) return;
            
            let children = actor.get_children ? actor.get_children() : [];
            if (children.length > 0) {
                this._overrideStyle(children[0], true);
            }
            return;
        }

        // Sauvegarde du style original
        if (actor._original_inline_style_ === undefined) {
            actor._original_inline_style_ = actor.get_style() || '';
        }

        actor.set_style(`${this._styleLine}; ${actor._original_inline_style_}`);

        // Gestion du signal style-changed pour éviter que GNOME n'écrase nos modifs
        if (!actor._spacingSignalID) {
            actor._spacingSignalID = actor.connect('style-changed', () => {
                let currStyle = actor.get_style();
                if (currStyle && !currStyle.includes(this._styleLine)) {
                    actor._original_inline_style_ = currStyle;
                    this._overrideStyle(actor);
                }
            });
        }
    }

    _restoreOriginalStyle(actor, secondTime = false) {
        if (!actor || !actor.has_style_class_name) return;

        if (!actor.has_style_class_name('panel-button')) {
            if (secondTime) return;
            let children = actor.get_children ? actor.get_children() : [];
            if (children.length > 0) {
                this._restoreOriginalStyle(children[0], true);
            }
            return;
        }

        if (actor._spacingSignalID) {
            actor.disconnect(actor._spacingSignalID);
            delete actor._spacingSignalID;
        }

        if (actor._original_inline_style_ !== undefined) {
            actor.set_style(actor._original_inline_style_);
            delete actor._original_inline_style_;
        }
    }

    _applyStyles() {
        const padding = this._settings.get_int('hpadding');
        this._styleLine = `-natural-hpadding: ${padding}px`;
        
        if (padding < 6) {
            this._styleLine += `; -minimum-hpadding: ${padding}px`;
        }

        // Application aux éléments existants dans la zone de gauche
        let leftBox = Main.panel._leftBox;
        leftBox.get_children().forEach(child => this._overrideStyle(child));

        // Signal pour les futurs éléments ajoutés
        this._actorAddedID = leftBox.connect('child-added', (container, actor) => {
            this._overrideStyle(actor);
        });
    }

    _removeStyles() {
        let leftBox = Main.panel._leftBox;

        if (this._actorAddedID) {
            leftBox.disconnect(this._actorAddedID);
            this._actorAddedID = 0;
        }

        leftBox.get_children().forEach(child => this._restoreOriginalStyle(child));
    }
}
