import { ExtensionPreferences } from 'resource:///org/gnome/Shell/Extensions/js/extensions/prefs.js';
import Gtk from 'gi://Gtk';
import Adw from 'gi://Adw';
import Gio from 'gi://Gio'; // <--- L'import manquant est ici

export default class IconAreaHorizontalSpacingPrefs extends ExtensionPreferences {
    fillPreferencesWindow(window) {
        const settings = this.getSettings();

        const page = new Adw.PreferencesPage();
        const group = new Adw.PreferencesGroup({
            title: 'Réglages',
            description: 'Ajuster l\'espacement horizontal des icônes du panel'
        });
        page.add(group);

        const row = new Adw.ActionRow({
            title: 'Marge horizontale (Padding)',
            subtitle: 'Définit l\'espace entre les icônes (par défaut: 12)'
        });

        const slider = new Gtk.Scale({
            orientation: Gtk.Orientation.HORIZONTAL,
            adjustment: new Gtk.Adjustment({
                lower: 0,
                upper: 18,
                step_increment: 1,
                page_increment: 1,
                value: settings.get_int('hpadding')
            }),
            digits: 0,
            hexpand: true,
            valign: Gtk.Align.CENTER,
            draw_value: true
        });

        // Liaison du slider aux paramètres GSettings
        settings.bind(
            'hpadding',
            slider.get_adjustment(),
            'value',
            Gio.SettingsBindFlags.DEFAULT
        );

        row.add_suffix(slider);
        row.activatable_widget = slider;
        group.add(row);

        window.add(page);
    }
}
