# Icon Area Horizontal Spacing

A GNOME Shell extension to customize and reduce the horizontal padding between icons located in the top-left area of the panel.

---

## 🧩 About GNOME Shell Extensions
GNOME Shell extensions are powerful add-ons that allow users to customize their desktop experience. They interface directly with the GNOME Shell UI, enabling developers to modify behaviors, styles, and layouts that are not available in the standard system settings.

## 🚀 What This Extension Does
This extension is a specialized fork of the "Status Area Horizontal Spacing" extension. While the original focused on the right-hand status icons, **Icon Area Horizontal Spacing** targets the **left box** (`_leftBox`) of the top panel.

### Key Features:
* **Custom Left-Side Padding**: Precisely adjust the horizontal spacing (`hpadding`) between elements in the left panel area (often where application menus or specific system icons reside).
* **Dynamic Style Overrides**: Changes applied in the settings are reflected instantly without needing to restart the shell.
* **Intelligent Scaling**: Automatically manages both natural and minimum horizontal padding to ensure a compact and consistent look.
* **Stability**: Includes safeguards to prevent GNOME from overwriting your custom styles while the extension is active, and restores original styles perfectly when disabled.

## ⚙️ Configuration
The extension uses GSettings to manage its configuration:
* **Schema ID**: `org.gnome.shell.extensions.icon-area-horizontal-spacing`
* **Key**: `hpadding` (Integer)

## 🛠 Installation

### From GNOME Extensions Website
The easiest way to install is via the [official GNOME Extensions portal](https://extensions.gnome.org/). The system will automatically handle the schema compilation for you.

### Manual Installation (Development / Git Clone)
If you are installing from source (e.g., via `git clone`), you **must** compile the GSettings schema manually for the extension to function correctly:

1. **Clone the repository** into your local extensions directory:
```bash
   git clone <repository-url> ~/.local/share/gnome-shell/extensions/icon-area-horizontal-spacing@kirby_33@hotmail.fr

```

2. **Navigate to the extension directory**:
```bash
cd ~/.local/share/gnome-shell/extensions/icon-area-horizontal-spacing@kirby_33@hotmail.fr

```


3. **Compile the schema**:
Execute this command to generate the necessary `gschemas.compiled` file:
```bash
glib-compile-schemas schemas/

```


*Note: Without this step, the extension will fail to load as it won't be able to find its settings.*
4. **Restart GNOME Shell**:
* **X11**: Press `Alt+F2`, type `r`, and hit `Enter`.
* **Wayland**: Log out and log back in.


5. **Enable the extension**:
Use the **Extensions** app or run:
```bash
gnome-extensions enable icon-area-horizontal-spacing@kirby_33@hotmail.fr

```



## 💻 Compatibility

Fully updated and tested for:

* **GNOME 45**
* **GNOME 46**
* **GNOME 47**

## 📜 Credits

* **Original Author**: [mathematical.coffee](https://github.com/mathematicalcoffee) (for the "Status Area Horizontal Spacing" logic).
* **Fork & Maintenance**: Adapted to target the Left Area of the GNOME panel.

## 📄 License

This project is released under the same open-source terms as the original extension.

