// Copyright (C) 2012 Nanakos Chrysostomos <nanakos@wired-net.gr>
// Soft-Yubikey Gnome Shell Extension
const St = imports.gi.St;
const Main = imports.ui.main;
const Tweener = imports.ui.tweener;
const Shell = imports.gi.Shell;
const GLib = imports.gi.GLib;

let text, button;

function _hideOTP() {
    Main.uiGroup.remove_actor(text);
    text = null;
}

function _CreateOTP() {
    if (!text) {
        text = new St.Label({ style_class: 'create-otp', text: "OTP created" });
        Main.uiGroup.add_actor(text);
    }

    text.opacity = 255;
    let monitor = Main.layoutManager.primaryMonitor;
    text.set_position(Math.floor(monitor.width / 2 - text.width / 2),
                      Math.floor(monitor.height / 2 - text.height / 2));
    Tweener.addTween(text,
                     { opacity: 0,
                       time: 2,
                       transition: 'easeOutQuad',
                       onComplete: _hideOTP });
//	let _appSys = Shell.AppSystem.get_default();
//	let _gsmPrefs = _appSys.lookup_app('gedit.desktop');
//	_gsmPrefs.activate();
	let Gerror = 0;
	GLib.spawn_command_line_async("/usr/bin/ykey '\n'",Gerror);
}

function init() {
    button = new St.Bin({ style_class: 'panel-button',
                          reactive: true,
                          can_focus: true,
                          x_fill: true,
                          y_fill: false,
                          track_hover: true });
    let icon = new St.Icon({ icon_name: 'system-run',
                             icon_type: St.IconType.SYMBOLIC,
                             style_class: 'system-status-icon' });
    button.set_child(icon);
    button.connect('button-press-event', _CreateOTP);
}

function enable() {
    Main.panel._leftBox.insert_actor(button, 3);
}

function disable() {
    Main.panel._rightBox.remove_actor(button);
}
